<?php

namespace Modules\Banner\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Core\Traits\CanPublishConfiguration;
use Modules\Core\Events\BuildingSidebar;
use Modules\Core\Events\LoadingBackendTranslations;
use Modules\Banner\Events\Handlers\RegisterBannerSidebar;

class BannerServiceProvider extends ServiceProvider
{
    use CanPublishConfiguration;
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->registerBindings();
        $this->app['events']->listen(BuildingSidebar::class, RegisterBannerSidebar::class);

        $this->app['events']->listen(LoadingBackendTranslations::class, function (LoadingBackendTranslations $event) {
            $event->load('banners', array_dot(trans('banner::banners')));
            // append translations

        });
    }

    public function boot()
    {
        $this->publishConfig('banner', 'permissions');

        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return array();
    }

    private function registerBindings()
    {
        $this->app->bind(
            'Modules\Banner\Repositories\BannerRepository',
            function () {
                $repository = new \Modules\Banner\Repositories\Eloquent\EloquentBannerRepository(new \Modules\Banner\Entities\Banner());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Banner\Repositories\Cache\CacheBannerDecorator($repository);
            }
        );
// add bindings

    }
}
