<?php
namespace Modules\Category\Http\Controllers\Api;
use Modules\Core\Http\Controllers\BasePublicController;
use Illuminate\Routing\Controller;
use Illuminate\Http\Request;
use Modules\User\Http\Requests\LoginRequest;
use Illuminate\Http\Response;
use Validator;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Contracts\Auth\Guard;
use Modules\User\Repositories\UserRepository;
use Modules\User\Repositories\RoleRepository;
use Modules\User\Contracts\Authentication;
use Modules\User\Entities\UserToken;
use Modules\User\Repositories\UserTokenRepository;
use Modules\User\Transformers\ApiKeysTransformer;
use Modules\User\Transformers\UserProfileTransformer;
use Modules\Userlist\Repositories\UserlistRepository;
use Modules\Category\Repositories\CategoryRepository;
use Modules\Banner\Repositories\BannerRepository;
use Modules\Event\Repositories\EventRepository;
use Modules\Event\Repositories\EventdetailsRepository;
use Modules\Userlist\Repositories\ManagerRepository;
use Modules\Location\Repositories\cityRepository;
use Modules\Location\Repositories\LocationRepository;
use Modules\Wallet\Repositories\WalletRepository;
use Modules\Wallet\Repositories\TransactionRepository;
use Modules\Userlist\Repositories\ReviewRepository;
use Modules\Userlist\Repositories\LatlongRepository;
use DB;
use Carbon;
use DateTime;

class CategoryApiController extends BasePublicController
{
   protected $guard;
   public function __construct(Response $response, Guard $guard, UserRepository $user,RoleRepository $role,Authentication $auth, UserTokenRepository $userToken,UserlistRepository $userlist,CategoryRepository $category,BannerRepository $banner,EventRepository $event,EventdetailsRepository $eventdetails,ManagerRepository $manager,cityRepository $city,LocationRepository $location,WalletRepository $wallet,TransactionRepository $transaction,ReviewRepository $review,LatlongRepository $latlong)
   {
      parent::__construct();
      $this->response = $response;
      $this->guard = $guard;
      $this->user = $user;
      $this->role = $role;
      $this->auth = $auth;
      $this->userToken = $userToken;
      $this->userlist = $userlist;
      $this->category = $category;
      $this->banner = $banner;
      $this->event = $event;
      $this->eventdetails = $eventdetails;
      $this->manager = $manager;
      $this->city = $city;
      $this->location = $location;
      $this->wallet = $wallet;
      $this->transaction = $transaction;
      $this->review = $review;
      $this->latlong = $latlong;
   }
   public function login(Request $request,Client $http) {
        $validator = Validator::make($request->all(), [
          'phone' => 'required',
          'password' => 'required'
        ]);
        if ($validator->fails()) {
          $errors = $validator->errors();
            foreach ($errors->all() as $message) {
              $meserror =$message;
           }
           return $this->response->setStatusCode(401,$meserror);
       } else {
       if(Auth::attempt(['phone' => $request->phone, 'password' => $request->password])) {
          $userAuth = $this->auth->user();
           if($this->user->find($userAuth->id)->isActivated() && isset($userAuth->roles[0]->slug) && $userAuth->roles[0]->slug == 'user'){
               $token = $this->userToken->generateFor($userAuth->id);
               return response()->json([
                   'errors' => false,
                   'message' => trans('user::users.token generated'),
                   'data' => $token,
               ]);
             }
             else
             {
               return response()->json([
                   'errors' => true,
                   'message' => trans('Invalid Phone Number or Password')
               ]);
             }
       }
       else
       {
         return response()->json([
                   'errors' => true,
                   'message' => trans('Invalid Phone Number or Password')
               ]);
       }
     }
   }



   // USER APP APIS


  public function otp(Request $request,Client $http) {
    $validator = Validator::make($request->all(), [
       'phone' => 'required|regex:/^([0-9]*)$/|min:10|max:10',
       'code' => 'required'
     ]);

    if($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
    } else {
      if(Auth::attempt(['phone' => $request->phone, 'role' => 'user'])) {
        $userAuth = $this->auth->user();
          if($this->user->find($userAuth->id)->isActivated() && isset($userAuth->role) && $userAuth->role == 'user') {
            $token = $this->userToken->generateFor($userAuth->id);
            $phone = $request->phone;
            $otp = rand(100000 , 999999);
            $text = urlencode("<#>%20Your%20verification%20code%20is:%20".$otp."%20Message%20ID%20:%20".$request->code);
            $url = "https://control.msg91.com/api/sendhttp.php?authkey=180041Ak6emp1IxdL59e8aecf&mobiles=".$phone."&message=".$text."&sender=HASHVA&route=4&country=91";
            $return = file($url);
            return response()->json([
                      'errors' => false,
                      'message' => trans('Otp sent successfully'),
                      'otp' => $otp,
                      'token' => $token
                  ]);
              }
        } else {
          $phone = $request->phone;
          $otp = rand(100000 , 999999);
          $text = urlencode("<#>%20Your%20verification%20code%20is:%20".$otp."%20Message%20ID%20:%20".$request->code);
          $url = "https://control.msg91.com/api/sendhttp.php?authkey=180041Ak6emp1IxdL59e8aecf&mobiles=".$phone."&message=".$text."&sender=HASHVA&route=4&country=91";
          $return = file($url);
          return response()->json([
                        'errors' => false,
                        'message' => trans('Otp sent successfully'),
                        'otp' => $otp,
                        'token' => null
                    ]);
        }
      }
  }

  public function register(Request $request,Client $http) {
     $validator = Validator::make($request->all(), [
       'email' => 'required|unique:users|email',
       'phone' => 'required|min:10|max:10|unique:users',
       'first_name' => 'required',
       'last_name' => 'required',
       'gender' => 'required',
       'findus' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return response()->json([
                 'errors' => true,
                 'message' => $meserror
             ]);
     } else {
        $role_type = $this->role->findByName(['name' => "user"]);
        if(isset($role_type->name)){
            $request->merge(['password' => $request->phone,'role' => 'user']);
            $user_detail = $this->user->createWithRoles($request->all(),$role_type->id,true);
            $ddd = DB::table('users')
                  ->where('id', $user_detail->id)
                  ->update(['role' => 'user']);
           if(isset($user_detail->id))
           {
              function generateRandomString($length = 2) {
                  $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                  $charactersLength = strlen($characters);
                  $randomString = '';
                  for ($i = 0; $i < $length; $i++) {
                    $randomString .= $characters[rand(0, $charactersLength - 1)];
                  }
                  return $randomString;
              }
              $member_id = "ITI".generateRandomString().$user_detail->id;
              $request->merge(['user_id' => $user_detail->id, 'member_id' => $member_id]);
              
              if(isset($request->referalcode)) {
                $request->merge(['referalcode' => $request->referalcode]);
              }

              $fff = DB::table('wallet__wallets')->insert([
                ['user_id' => $user_detail->id, 'amount' => 0]
              ]);
              $userslist = $this->userlist->create($request->all());
              $token = $this->userToken->generateFor($user_detail->id);
                
              return response()->json([
                'errors' => false,
                'message' => trans('Register Successful'),
                'token' => $token
              ]);
            }
          } else {
            $this->response->setContent(array('errors' => true,'message'=>'Email or Password is invalid'));
            return $this->response->setStatusCode(401,'Email or Password is invalid');
        }
    }
  }

  
  public function city() {
   $locations = $this->location->getByAttributes(['status' => 1]);
   
    return response()->json([
     'errors' => false,
     'message' => trans('Cities'),
     'data' => $locations,
   ]);
  }

  public function location(Request $request,Client $http) {
    $validator = Validator::make($request->all(), [
       'city_id' => 'required',
    ]);
    if ($validator->fails()) {
      $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
       $locations = $this->location->getByAttributes(['c_id' => $request->city_id]);
       
       return response()->json([
         'errors' => false,
         'message' => trans('Locations'),
         'data' => $locations,
       ]);
     }
  }

  public function filter_events(Request $request,Client $http) {
    $validator = Validator::make($request->all(), [
       'city_id' => 'required',
       'cat_id' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
      $datetoday=date('Y-m-d');
      if($request->cat_id == 0){
         $events = DB::table('event__events')->where('status', '=', 1)->where('location_id', '=', $request->city_id)->where('todate', '<=', $datetoday)->get();
         foreach ($events as $event) {
            $event->location = DB::table('location__locations')->where('id', '=', $event->location_id)->get();
         }
        // $events = $this->event->getByAttributes(['location_id' => $request->city_id]);
      }else{
        $events = DB::table('event__events')->where('status', '=', 1)->where('location_id', '=', $request->city_id)->where('location_id', '=', $request->city_id)->where('cat_id', '=', $request->cat_id)->where('todate', '<=', $datetoday)->get();
         foreach ($events as $event) {
            $event->location = DB::table('location__locations')->where('id', '=', $event->location_id)->get();
         }
       // $events = $this->event->getByAttributes(['location_id' => $request->city_id,'cat_id' => $request->cat_id]);
     }
       
       return response()->json([
         'errors' => false,
         'message' => trans('Filter'),
         'data' => $events,
       ]);
     }
  }

  public function filter(Request $request,Client $http) {
    if(isset($request->city_id) && $request->city_id != "" && isset($request->cat_id) && $request->cat_id != "") {
      $events = $this->event->getByAttributes(['location_id' => $request->city_id, 'cat_id' => $request->cat_id]);
    } elseif (isset($request->city_id) && $request->city_id != "") {
      $events = $this->event->getByAttributes(['location_id' => $request->city_id]);
    } elseif (isset($request->cat_id) && $request->cat_id != "") {
      $events = $this->event->getByAttributes(['cat_id' => $request->cat_id]);
    } else {
        return response()->json([
         'errors' => false,
         'message' => trans('No Data Found'),
         'data' => [],
       ]);
    }
    if(isset($events[0]->id)) {
      return response()->json([
         'errors' => false,
         'message' => trans('City Filter'),
         'data' => $events,
       ]);
    } else {
      return response()->json([
         'errors' => false,
         'message' => trans('No Data Found'),
         'data' => [],
       ]);
    }
  } 

  public function current_location(Request $request,Client $http){
    $validator = Validator::make($request->all(), [
       'latitude' => 'required',
       'longitude' => 'required'
     ]);  

     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
      $userId = $this->auth->id();
      $check_location = $this->latlong->findByAttributes(['user_id' => $userId]);
      if(isset($check_location->id)) {
        $this->latlong->update($check_location, $request->all());
      } else {
        $request->merge(['user_id' => $userId]);
        $this->latlong->create($request->all());
      }

        $date = date('Y-m-d');
        $query = "SELECT *,( 6371* acos( cos( radians('$request->latitude') ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians('$request->longitude') )+ sin( radians('$request->latitude') ) * sin( radians( latitude ) ) ) ) AS distance FROM event__events where status = 1 and todate > '$date' HAVING distance < 100 ORDER BY distance LIMIT 0 , 100";
        $data = DB::select($query);
        
          return response()->json([
           'errors' => false,
           'message' => trans('Curent Location Distance'),
           'data' => $data,
         ]);
    }
  }

  public function user_enrolls(Request $request,Client $http){
    $validator = Validator::make($request->all(), [
       'event_id' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
          $event_enroll = $this->eventdetails->getByAttributes(['event_id' => $request->event_id]);
          foreach ($event_enroll as $event) {
              $event->user;
              $event->event;
              $event->location = $this->latlong->findByAttributes(['user_id' => $event->user_id]);
              $event->ratings = $this->getTotalRating($event->user['id']);
              if(isset($event->location['updated_at'])) {
                $event->last_updated = $this->timeago($event->location['updated_at']);
              } else {
                  $event->last_updated = "Location Not Found";
              }
           }

          return response()->json([
           'errors' => false,
           'message' => trans('Enrolled Users'),
           'data' => $event_enroll,
         ]);
    }
  }

    public function getTotalRating($userid) {
      $reviews = $this->review->getByAttributes(['user_id' => $userid], 'id', 'desc');
      $total = 0;
      $count = 0;
      foreach ($reviews as $review) {
        $total = $total + $review->rating;
        $count = $count + 1;
        $review->manager;
        $review->image = "assets/media/15905562971590556295914.jpg";
        $review->time = $review->created_at;
      }
      
      if(isset($reviews[0]->id)) {
        $total_ratings = number_format(($total / $count),1);
        return $total_ratings;
      } else {
        return 0;
      }
    }

    public function timeago($time, $tense='ago') {
      static $periods = array('year', 'month', 'day', 'hour', 'minute', 'second');
      if(!(strtotime($time)>0)) {
          return trigger_error("Wrong time format: '$time'", E_USER_ERROR);
      }

      $now  = new DateTime('now');
      $time = new DateTime($time);
      $diff = $now->diff($time)->format('%y %m %d %h %i %s');
      $diff = explode(' ', $diff);
      $diff = array_combine($periods, $diff);
      $diff = array_filter($diff);
      $period = key($diff);
      $value  = current($diff);
      if(!$value) {
          $period = 'seconds';
          $value  = 0;
      } else {
          if($period=='day' && $value>=7) {
              $period = 'week';
              $value  = floor($value/7);
          }
          if($value>1) {
              $period .= 's';
          }
      }
      return "$value $period $tense";
    }

  public function user_upcoming_events() {
    $userId = $this->auth->id();
    $event_enroll = $this->eventdetails->getByAttributes(['user_id' => $userId,'status' => 2]);
    foreach ($event_enroll as $event) {
      $event->user;
      $event->event;
      $events = $this->event->getByAttributes(['id' => $event->event_id]);
      foreach ($events as $value) {
        if(isset($value->manager_id)){
            $event->manager = $this->manager->getByAttributes(['user_id' => $value->manager_id]);
          }
      }
    }
   return response()->json([
     'errors' => false,
     'message' => trans('Events'),
     'data' => $event_enroll,
   ]);
 }

  public function user_completed_events() {
    $userId = $this->auth->id();
    $event_enroll = $this->eventdetails->getByAttributes(['user_id' => $userId,'status' => 3]);
    foreach ($event_enroll as $event) {
      $event->user;
      $event->event;
      $events = $this->event->getByAttributes(['id' => $event->event_id]);
      foreach ($events as $value) {
        $event->manager = $this->manager->getByAttributes(['user_id' => $value->manager_id]);
      }
    }
    return response()->json([
      'errors' => false,
      'message' => trans('Events'),
      'data' => $event_enroll,
     ]);
  }

  public function user_all_events() {
    $userId = $this->auth->id();
    $event_enroll = $this->eventdetails->getByAttributes(['user_id' => $userId]);
    foreach ($event_enroll as $event) {
      $event->user;
      $event->event;
      $events = $this->event->getByAttributes(['id' => $event->event_id]);
      foreach ($events as $value) {
        if(isset($value->manager_id)){
            $event->manager = $this->manager->getByAttributes(['user_id' => $value->manager_id]);
          }
      }
      
    }
    return response()->json([
     'errors' => false,
     'message' => trans('Events'),
     'data' => $event_enroll,
    ]);
  }

  public function cancel_event(Request $request,Client $http){
    $validator = Validator::make($request->all(), [
       'event_id' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
          $userId = $this->auth->id();
          $events = DB::table('event__eventdetails')
                  ->where('event_id', $request->event_id)
                  ->where('user_id', $userId)
                  ->update(['status' => 4]);
         
          return response()->json([
           'errors' => false,
           'message' => trans('Event Cancelled'),
           'data' => $events,
         ]);
   }
 }


  public function event_details(Request $request,Client $http) {
    $validator = Validator::make($request->all(), [
       'id' => 'required',
       'latitude' => 'required',
       'longitude' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
          $userId = $this->auth->id();
          $events = $this->event->getByAttributes(['id' => $request->id]);
          foreach ($events as $event) {
             $event->location;
             $event_enrolls = $this->eventdetails->findByAttributes(['event_id' => $event->id,'user_id' => $userId]);
             if(isset($event_enrolls->id)){
                $event->enroll_status = $event_enrolls->status;
             } else {
                 $event->enroll_status = 0;
             }
             $data = DB::select('SELECT *,( 6371* acos( cos( radians('.$request->latitude.') ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians('.$request->longitude.') )+ sin( radians('.$request->latitude.') ) * sin( radians( latitude ) ) ) ) AS distance FROM event__events where id = '.$event->id.'');
             $event->distance = $data[0]->distance;
             if(isset($event->manager_id)){
                $event->manager = $this->user->find($event->manager_id);
             }
             $event->category;
           }
          return response()->json([
           'errors' => false,
           'message' => trans('Event Details'),
           'data' => $events,
         ]);
   }
 }

 public function event_enroll(Request $request,Client $http){

    $validator = Validator::make($request->all(), [
       'event_id' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
          $userId = $this->auth->id();
          $event_enrolls = $this->eventdetails->findByAttributes(['event_id' => $request->event_id,'user_id' => $userId]);
          if(isset($event_enrolls->id)){
            return response()->json([
                     'errors' => true,
                     'message' => trans('Already Enrolled to event'),
                     'data' => null,
                    ]);
            } else  {
              $events = $this->event->findByAttributes(['id' => $request->event_id]);
              if(isset($events->id)) {
                $request->merge(['user_id' => $userId,'price' => $events->price]);
                $event_enroll = $this->eventdetails->create($request->all());
                return response()->json([
                 'errors' => false,
                 'message' => trans('Event Enroll'),
                 'data' => $event_enroll,
               ]);
              } else {
                return response()->json([
                     'errors' => true,
                     'message' => trans('Invalid Event'),
                     'data' => null,
                    ]);
              }
              
          }
      }
  }

    public function account_info_user(Request $request,Client $http) {
      $userId = $this->auth->id();
          if(isset($request->phone_pe)){
              $userlist = DB::table('userlist__userlists')
                          ->where('user_id', $userId)
                          ->update(['phone_pe' => $request->phone_pe]);
          }
          if(isset($request->google_pay)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['google_pay' => $request->google_pay]);
          }
          if(isset($request->dob)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['dob' => $request->dob]);
          }
          if(isset($request->bhim)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['bhim' => $request->bhim]);
          }
          if(isset($request->account_holder_name)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['account_holder_name' => $request->account_holder_name]);
          }
          if(isset($request->account_number)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['account_number' => $request->account_number]);
          }
          if(isset($request->ifsc_code)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['ifsc_code' => $request->ifsc_code]);
          }
          if(isset($request->branch)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['branch' => $request->branch]);
          }

          if(isset($request->pan)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['pan' => $request->pan]);
          }

          if(isset($request->bio)){
            $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['bio' => $request->bio]);
          }

          if(isset($request->category)){
              $userlist = DB::table('userlist__userlists')
                          ->where('user_id', $userId)
                          ->update(['category' => $request->category]);
          }

          if(isset($request->image) && $request->image){
              $file_name = $_FILES['image']['name'];
              $file_size =$_FILES['image']['size'];
              $file_tmp =$_FILES['image']['tmp_name'];
              $file_type=$_FILES['image']['type'];
              $expensions= array("jpeg","jpg","png");

              $newfile = "assets/media/".time().$file_name;

              if($file_size > 2097152){
                 $errors[]='File size must be excately 2 MB';
              }
              
              if(empty($errors)==true) {
                 move_uploaded_file($file_tmp,$newfile);
                 $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['photo' => $newfile]);
              }
            }

            if(isset($request->cheque) && $request->cheque){
              $file_name = $_FILES['cheque']['name'];
              $file_size =$_FILES['cheque']['size'];
              $file_tmp =$_FILES['cheque']['tmp_name'];
              $file_type=$_FILES['cheque']['type'];
              $expensions= array("jpeg","jpg","png");

              $newfile = "assets/media/".time().$file_name;

              if($file_size > 2097152){
                 $errors[]='File size must be excately 2 MB';
              }
              
              if(empty($errors)==true){
                 move_uploaded_file($file_tmp,$newfile);
                 $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['cheque_image' => $newfile]);
              }
            }
            if(isset($request->first_name)){
              $userlists = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['first_name' => $request->first_name,'last_name' => $request->last_name]);
              $userlist = DB::table('users')
                      ->where('id', $userId)
                      ->update(['first_name' => $request->first_name,'last_name' => $request->last_name]);
            }
            if(isset($request->facebook)){
              $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['facebook' => $request->facebook]);
            }
            if(isset($request->instagram)){
              $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['instagram' => $request->instagram]);
            }
            if(isset($request->twitter)){
              $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['twitter' => $request->twitter]);
            }

            if(isset($request->youtube)){
              $userlist = DB::table('userlist__userlists')
                      ->where('user_id', $userId)
                      ->update(['youtube' => $request->youtube]);
            }

          return response()->json([
           'errors' => false,
           'message' => trans('User Information Updated'),
           'data' => $userlist,
         ]);
  }

  public function wallet() {
    $userId = $this->auth->id();
    // $wallets = $this->wallet->getByAttributes(['user_id' => $userId]);
    $credit = $this->transaction->getByAttributes(['status' => 1,'user_id' => $userId])->sum('amount');
    $transfer = $this->transaction->getByAttributes(['status' => 4,'user_id' => $userId])->sum('amount');
    $requestd = $this->transaction->getByAttributes(['status' => 3,'user_id' => $userId])->sum('amount');
    $debit = $transfer + $requestd;
    $wallets = $credit - $debit;
   return response()->json([
     'errors' => false,
     'message' => trans('Wallet'),
     'data' => $wallets,
   ]);
  }

  public function transaction() {
    $userId = $this->auth->id();
    $transactions = $this->transaction->getByAttributes(['user_id' => $userId],'id','desc');
    foreach ($transactions as $transaction) {
        $event_name = DB::table('event__events')
                                ->select('name')
                                ->where('id', $transaction->event_id)->get();
        if(isset($event_name[0]->name)) {
          $transaction->event_name = $event_name[0]->name;
        } else {
          if($transaction->status == "3") {
            $transaction->event_name = "Withdrawal Request";
          } else {
            $transaction->event_name = "Transaction Successful";
          }
        }
    }
    return response()->json([
      'errors' => false,
      'message' => trans('Transaction'),
      'data' => $transactions,
    ]);
  }

  public function request_amount(Request $request,Client $http){
    $validator = Validator::make($request->all(), [
      'amount' => 'required'
    ]);
    if ($validator->fails()) {
      $errors = $validator->errors();
        foreach ($errors->all() as $message) {
          $meserror =$message;
        }
        return $this->response->setStatusCode(401,$meserror);
    } else {
      $datetoday=date("Y-m-d H:i:s");
      $userId = $this->auth->id();
      $fff = DB::table('wallet__transactions')->insert([
              ['user_id' => $userId, 'amount' => $request->amount,'transaction_id' => 'Requested', 'status' => 3,'created_at' => $datetoday]]);

      $request_amount = $this->transaction->getByAttributes(['user_id' => $userId],'id','desc');
      return response()->json([
        'errors' => false,
        'message' => trans('Amount Requested'),
        'data' => $request_amount,
      ]);
    }
  }

  public function category() {
    $categories = $this->category->getByAttributes(['status' => 1]);
    return response()->json([
     'errors' => false,
     'message' => trans('Categories'),
     'data' => $categories,
    ]);
  }



  // MANAGER APIS


  public function manager_otp(Request $request,Client $http){
    $validator = Validator::make($request->all(), [
       'phone' => 'required|regex:/^([0-9]*)$/|min:10|max:10',
       'code' => 'required'
     ]);

    if($validator->fails()) {
        $errors = $validator->errors();
          foreach ($errors->all() as $message) {
            $meserror =$message;
          }
          return $this->response->setStatusCode(401,$meserror);
    } else {
        if(Auth::attempt(['phone' => $request->phone,'role' => 'manager'])) {
          $userAuth = $this->auth->user();
            if($this->user->find($userAuth->id)->isActivated() && isset($userAuth->role) && $userAuth->role == 'manager') {
                $token = $this->userToken->generateFor($userAuth->id);
                     
                $phone = $request->phone;
                $otp = rand (100000 , 999999);
                $text = urlencode("<#>%20Your%20verification%20code%20is:%20".$otp."%20Message%20ID%20:%20".$request->code);
                $url = "https://control.msg91.com/api/sendhttp.php?authkey=180041Ak6emp1IxdL59e8aecf&mobiles=".$phone."&message=".$text."&sender=HASHVA&route=4&country=91";
                $return = file($url);
                return response()->json([
                  'errors' => false,
                  'message' => trans('Otp sent successfully'),
                  'otp' => $otp,
                  'token' => $token
                ]);
              } else {
                return response()->json([
                  'errors' => true,
                  'message' => trans('Mobile Number Not Registered'),
                  'token' => null
                ]);
              }
          } else {
              return response()->json([
                  'errors' => true,
                  'message' => trans('Mobile Number Not Registered'),
                  'token' => null
                ]);
          }
      }
  }
 
  

  public function city_events(Request $request,Client $http) {
    $validator = Validator::make($request->all(), [
       'city_id' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
       $events = $this->event->getByAttributes(['location_id' => $request->city_id]);
       
       return response()->json([
         'errors' => false,
         'message' => trans('City Filter'),
         'data' => $events,
       ]);
     }
 }

  

  public function category_events(Request $request,Client $http) {
    $validator = Validator::make($request->all(), [
       'cat_id' => 'required'
     ]);
    
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
            $events = DB::table('event__events')
                      ->where('cat_id', 'LIKE', '%' . $request->cat_id . '%')->get();
          
          return response()->json([
           'errors' => false,
           'message' => trans('Category Events'),
           'data' => $events,
         ]);
    }
  }

  

  public function category_list(Request $request,Client $http){
     $validator = Validator::make($request->all(), [
       'cat_id' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
          $categories = $this->category->findByAttributes(['id' => $request->cat_id]);
          
          return response()->json([
           'errors' => false,
           'message' => trans('Categories'),
           'data' => $categories,
         ]);
    }
  }


  public function events() {
    $month = Carbon\Carbon::today()->month;
    $date_now = Carbon\Carbon::today()->day;
    $datetoday=date('Y-m-d');

    $events = DB::table('event__events')->where('status', '=', 1)->where('todate', '<=', $datetoday)->get();
    foreach ($events as $event) {
      $event->location = DB::table('location__locations')->where('id', '=', $event->location_id)->get();
     }
     return response()->json([
       'errors' => false,
       'message' => trans('Events'),
       'data' => $events,
     ]);
  }

  public function manager_events(Request $request,Client $http) {
  $validator = Validator::make($request->all(), [
       'latitude' => 'required',
       'longitude' => 'required'
     ]);
     if ($validator->fails()) {
       $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
      $userId = $this->auth->id();
      $events = $this->event->getByAttributes(['manager_id' => $userId]);
      foreach ($events as $event) {
        $event->location;
        $event_enrolls = $this->eventdetails->getByAttributes(['event_id' => $event->id,'status' => 1]);
          foreach ($event_enrolls as $value) {
            $event->user = $this->userlist->getByAttributes(['user_id' => $value->user_id]);
          }
          $data = DB::select('SELECT *,( 6371* acos( cos( radians('.$request->latitude.') ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians('.$request->longitude.') )+ sin( radians('.$request->latitude.') ) * sin( radians( latitude ) ) ) ) AS distance FROM event__events where id = '.$event->id.'');
          $event->distance = $data[0]->distance;
      }
      return response()->json([
          'errors' => false,
          'message' => trans('Events'),
          'data' => $events,
      ]);
    }
  }

  public function manager_upcoming_events(Request $request,Client $http) {
  $validator = Validator::make($request->all(), [
       'latitude' => 'required',
       'longitude' => 'required'
  ]);  

  if($validator->fails()) {
    $errors = $validator->errors();
         foreach ($errors->all() as $message) {
           $meserror =$message;
         }
         return $this->response->setStatusCode(401,$meserror);
     } else {
         
            $userId = $this->auth->id();
           $events = $this->event->getByAttributes(['manager_id' => $userId, 'status' => 1]);
           foreach ($events as $event) {
             $event->location;
             $data = DB::select('SELECT *,( 6371* acos( cos( radians('.$request->latitude.') ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians('.$request->longitude.') )+ sin( radians('.$request->latitude.') ) * sin( radians( latitude ) ) ) ) AS distance FROM event__events where id = '.$event->id.'');
                     $event->distance = $data[0]->distance;
           }
           return response()->json([
             'errors' => false,
             'message' => trans('Events'),
             'data' => $events,
           ]);
     }
 }

    public function manager_completed_events() {
      $userId = $this->auth->id();
      $events = $this->event->getByAttributes(['manager_id' => $userId, 'status' => 0]);
      foreach ($events as $event) {
        $event->location;
      }
      return response()->json([
        'errors' => false,
        'message' => trans('Events'),
        'data' => $events,
      ]);
    }

    public function verify_code(Request $request,Client $http){
      $validator = Validator::make($request->all(), [
         'ver_code' => 'required',
         'event_id' => 'required'
       ]);
       if ($validator->fails()) {
         $errors = $validator->errors();
           foreach ($errors->all() as $message) {
             $meserror =$message;
           }
           return $this->response->setStatusCode(401,$meserror);
       } else {
            $userId = $this->auth->id();
            $event_enroll = $this->eventdetails->findByAttributes(['event_id' => $request->event_id,'user_id' => $request->user_id, 'ver_code' => $request->ver_code]);
            if(isset($event_enroll->id)){
              $events = $this->eventdetails->update($event_enroll, ['status' => 3]);
             
              return response()->json([
               'errors' => false,
               'message' => trans('Accepted'),
               'data' => $events,
             ]);
          } else {
            return response()->json([
               'errors' => false,
               'message' => trans('Wrong Verification Code'),
               'data' => NULL,
               ]);
          }
      }
    }

  public function account_info_manager(Request $request,Client $http){
    $userId = $this->auth->id();

    if(isset($request->company_name)){
      $userlist = DB::table('userlist__managers')
                      ->where('user_id', $userId)
                      ->update(['company_name' => $request->company_name]);
    }

    if(isset($request->gst)){
      $userlist = DB::table('userlist__managers')
                      ->where('user_id', $userId)
                      ->update(['gst' => $request->gst]);
    }

    if(isset($request->alternate_phone)){
      $userlist = DB::table('userlist__managers')
                      ->where('user_id', $userId)
                      ->update(['alternate_phone' => $request->alternate_phone]);
    }

    if(isset($request->alternate_email)){
      $userlist = DB::table('userlist__managers')
                      ->where('user_id', $userId)
                      ->update(['alternate_email' => $request->alternate_email]);
    }

    if(isset($request->image) && $request->image){
      $file_name = $_FILES['image']['name'];
      $file_size =$_FILES['image']['size'];
      $file_tmp =$_FILES['image']['tmp_name'];
      $file_type=$_FILES['image']['type'];  
      $expensions= array("jpeg","jpg","png");

      $newfile = "assets/media/".time().$file_name;

      if($file_size > 2097152){
        $errors[]='File size must be excately 2 MB';
      }
    
      if(empty($errors)==true){
        move_uploaded_file($file_tmp,$newfile);
        $userlist = DB::table('userlist__managers')
                      ->where('user_id', $userId)
                      ->update(['photo' => $newfile]);
        }
      }
    
      if(isset($request->first_name)){
        $userlist = DB::table('userlist__managers')
                      ->where('user_id', $userId)
                      ->update(['first_name' => $request->first_name,'last_name' => $request->last_name]);
        
        $userlist = DB::table('users')
                      ->where('id', $userId)
                      ->update(['first_name' => $request->first_name,'last_name' => $request->last_name]);
      }
      if(isset($userlist)) {
        return response()->json([
             'errors' => false,
             'message' => trans('Manager Information Updated'),
             'data' => $userlist,
        ]);
      } else {
        return response()->json([
             'errors' => false,
             'message' => trans('Nothing To Update'),
             'data' => null,
        ]);
      }
   }

    public function write_review(Request $request,Client $http){
      $validator = Validator::make($request->all(), [
        'rating' => 'required',
        'comment' => 'required',
        'user_id' => 'required'
      ]);
       
      if ($validator->fails()) {
        $errors = $validator->errors();
           foreach ($errors->all() as $message) {
             $meserror =$message;
           }
           return $this->response->setStatusCode(401,$meserror);
       } else {
            $userId = $this->auth->id();
            $request->merge(['manager_id' => $userId, 'status' => 1]);
            
            $review = $this->review->create($request->all());

            return response()->json([
               'errors' => false,
               'message' => trans('Review Successfully'),
               'data' => $review,
             ]);
        }
    }

    public function view_review(Request $request,Client $http) {
      $validator = Validator::make($request->all(), [
        'user_id' => 'required'
      ]);
       
      if ($validator->fails()) {
        $errors = $validator->errors();
           foreach ($errors->all() as $message) {
             $meserror =$message;
           }
           return $this->response->setStatusCode(401,$meserror);
       } else {
            $reviews = $this->review->getByAttributes(['user_id' => $request->user_id], 'id', 'desc');
            $total = 0;
            $count = 0;
            foreach ($reviews as $review) {
              $total = $total + $review->rating;
              $count = $count + 1;
              $review->manager;
              $review->image = $this->getManagerProfile($review->manager_id);
              $review->time = $this->timeago($review->created_at);
            }
            if(isset($reviews[0]->id)) {
              $review_data['total_ratings'] = number_format(($total / $count),1);
              $review_data['reviews'] = $reviews;
            return response()->json([
               'errors' => false,
               'message' => trans('Reviews'),
               'data' => $review_data,
             ]);
          } else {
            return response()->json([
               'errors' => true,
               'message' => trans('No Data Found'),
               'data' => null,
             ]);
          }
      }
    }

    public function getManagerProfile($member_id) {
      $member = $this->manager->findByAttributes(['user_id' => $member_id]);
      if(isset($member->id)) {
        return $member->photo;
      } else {
        return null;
      }
    }

    public function banner() {
      $banners = $this->banner->getByAttributes(['status' => 1]);
      return response()->json([
       'errors' => false,
       'message' => trans('Banner Images'),
       'data' => $banners,
      ]);
    }

    public function user_profile() {
      $userId = $this->auth->id();
      $userlists = $this->userlist->findByAttributes(['user_id' => $userId]);
      $userlists->categories = $this->category->getByAttributes(['status' => 1]);
      return response()->json([
       'errors' => false,
       'message' => trans('User Profile'),
       'data' => $userlists,
      ]);
    }
 
    public function manager_profile() {
      $userId = $this->auth->id();
      $managers = $this->manager->getByAttributes(['user_id' => $userId]);
      return response()->json([
        'error_log(message)rs' => false,
        'message' => trans('Manager Profile'),
        'data' => $managers,
      ]);
    }
 

    public function profile() {
      $userId = $this->auth->id();
      $profile = new UserProfileTransformer($this->auth->user());
      $profile_data = $this->userlist->findByAttributes(['user_id' => $profile->id]);
      return response()->json([
        'errors' => false,
        'message' => trans('User Profile'),
        'data' => $profile_data,
      ]);
    }

    public function logout() {
      $userAuth = $this->auth->user();
      if(isset($userAuth->id)) {
        $tokens = $this->userToken->allForUser($userAuth->id);
        if(isset($tokens[0]->id)) {
          foreach ($tokens as $token) {
            $this->userToken->destroy($token);
          }
          if(isset($tokens)){
            return response()->json([
              'errors' => false,
              'message' => trans('Logout Successful!')
            ]);
         } else {
             return response()->json([
               'errors' => true,
               'message' => trans('Please Try Again!')
             ]);
         }
       } else {
         return response()->json([
           'errors' => true,
           'message' => trans('Invalid Token!')
         ]);
       }
    } else {
       return response()->json([
         'errors' => true,
         'message' => trans('Invalid User!')
       ]);
    }
  }
}
