<?php
use Illuminate\Routing\Router;
/** @var Router $router */
$router->group(['prefix' => 'user'], function (Router $router) {
   $router->post('login', [
       'as' => 'CategoryApiController.api.login',
       'uses' => 'CategoryApiController@login',
   ]);
   $router->post('register', [
       'as' => 'CategoryApiController.api.register',
       'uses' => 'CategoryApiController@register',
   ]);
   $router->post('otp', [
       'as' => 'CategoryApiController.api.otp',
       'uses' => 'CategoryApiController@otp',
   ]);
   $router->post('manager_otp', [
       'as' => 'CategoryApiController.api.manager_otp',
       'uses' => 'CategoryApiController@manager_otp',
   ]);
   $router->get('category', [
       'as' => 'CategoryApiController.api.category',
       'uses' => 'CategoryApiController@category',
   ]);
});
$router->group(['prefix' => '/service', 'middleware' => ['api.token']], function (Router $router) {
   $router->group(['prefix' => 'services'], function (Router $router) {
    $router->get('/profile', [
        'as' => 'CategoryApiController.api.profile',
        'uses' => 'CategoryApiController@profile'
      ]);
    $router->get('/logout', [
        'as' => 'CategoryApiController.api.logout',
        'uses' => 'CategoryApiController@logout'
    ]);
    $router->post('event_enroll', [
       'as' => 'CategoryApiController.api.event_enroll',
       'uses' => 'CategoryApiController@event_enroll',
    ]);
    $router->get('category', [
       'as' => 'CategoryApiController.api.category',
       'uses' => 'CategoryApiController@category',
    ]);
    $router->get('banner', [
       'as' => 'CategoryApiController.api.banner',
       'uses' => 'CategoryApiController@banner',
    ]);
    $router->get('events', [
       'as' => 'CategoryApiController.api.events',
       'uses' => 'CategoryApiController@events',
    ]);
    $router->post('event_details', [
       'as' => 'CategoryApiController.api.event_details',
       'uses' => 'CategoryApiController@event_details',
    ]);

    $router->post('manager_events', [
       'as' => 'CategoryApiController.api.manager_events',
       'uses' => 'CategoryApiController@manager_events',
    ]);
    $router->post('user_enrolls', [
       'as' => 'CategoryApiController.api.user_enrolls',
       'uses' => 'CategoryApiController@user_enrolls',
    ]);
    $router->post('manager_upcoming_events', [
       'as' => 'CategoryApiController.api.manager_upcoming_events',
       'uses' => 'CategoryApiController@manager_upcoming_events',
    ]);
    $router->get('manager_completed_events', [
       'as' => 'CategoryApiController.api.manager_completed_events',
       'uses' => 'CategoryApiController@manager_completed_events',
    ]);

     $router->get('user_upcoming_events', [
       'as' => 'CategoryApiController.api.user_upcoming_events',
       'uses' => 'CategoryApiController@user_upcoming_events',
   ]);

     $router->get('user_completed_events', [
       'as' => 'CategoryApiController.api.user_completed_events',
       'uses' => 'CategoryApiController@user_completed_events',
   ]);

     $router->get('user_all_events', [
       'as' => 'CategoryApiController.api.user_all_events',
       'uses' => 'CategoryApiController@user_all_events',
   ]);

     $router->post('cancel_event', [
       'as' => 'CategoryApiController.api.cancel_event',
       'uses' => 'CategoryApiController@cancel_event',
   ]);

     $router->post('verify_code', [
       'as' => 'CategoryApiController.api.verify_code',
       'uses' => 'CategoryApiController@verify_code',
   ]);

      $router->post('account_info_manager', [
       'as' => 'CategoryApiController.api.account_info_manager',
       'uses' => 'CategoryApiController@account_info_manager',
   ]);

       $router->post('account_info_user', [
       'as' => 'CategoryApiController.api.account_info_user',
       'uses' => 'CategoryApiController@account_info_user',
   ]);
       $router->get('user_profile', [
       'as' => 'CategoryApiController.api.user_profile',
       'uses' => 'CategoryApiController@user_profile',
   ]);

       $router->get('manager_profile', [
       'as' => 'CategoryApiController.api.manager_profile',
       'uses' => 'CategoryApiController@manager_profile',
   ]);
   
   $router->get('city', [
       'as' => 'CategoryApiController.api.city',
       'uses' => 'CategoryApiController@city',
   ]);

       $router->post('location', [
       'as' => 'CategoryApiController.api.location',
       'uses' => 'CategoryApiController@location',
   ]);
      $router->post('city_events', [
       'as' => 'CategoryApiController.api.city_events',
       'uses' => 'CategoryApiController@city_events',
   ]);
    $router->get('wallet', [
       'as' => 'CategoryApiController.api.wallet',
       'uses' => 'CategoryApiController@wallet',
   ]);

    $router->get('transaction', [
       'as' => 'CategoryApiController.api.transaction',
       'uses' => 'CategoryApiController@transaction',
   ]);

    $router->post('current_location', [
       'as' => 'CategoryApiController.api.current_location',
       'uses' => 'CategoryApiController@current_location',
   ]);

    $router->post('category_events', [
       'as' => 'CategoryApiController.api.category_events',
       'uses' => 'CategoryApiController@category_events',
   ]);

    $router->post('category_list', [
       'as' => 'CategoryApiController.api.category_list',
       'uses' => 'CategoryApiController@category_list',
   ]);
    $router->post('request_amount', [
       'as' => 'CategoryApiController.api.request_amount',
       'uses' => 'CategoryApiController@request_amount',
   ]);
    $router->post('filter_events', [
       'as' => 'CategoryApiController.api.filter_events',
       'uses' => 'CategoryApiController@filter_events',
   ]);

  $router->post('filter', [
       'as' => 'CategoryApiController.api.filter',
       'uses' => 'CategoryApiController@filter',
   ]);
    $router->post('write_review', [
       'as' => 'CategoryApiController.api.write_review',
       'uses' => 'CategoryApiController@write_review',
    ]);

    $router->post('view_review', [
       'as' => 'CategoryApiController.api.view_review',
       'uses' => 'CategoryApiController@view_review',
    ]);

       
     });
 });


