<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEventEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('event__events', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->integer('cat_id')->unsigned();
            $table->integer('location_id')->unsigned();
            $table->string('name');
            $table->integer('req_volunteer');
            $table->string('place');
            $table->string('latitude');
            $table->string('longitude');
            $table->date('event_date');
            $table->time('event_time');
            $table->string('price');
            $table->string('hours');
            $table->string('short_desc');
            $table->string('description');
            $table->string('image11');
            $table->string('image12');
            $table->string('image13');
            $table->string('image14');
            $table->text('address');
            $table->boolean('status')->default(1);
            $table->timestamps();

             $table->foreign('cat_id')->references('id')->on('category__categories')->onDelete('cascade');
             $table->foreign('location_id')->references('id')->on('location__locations')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('event__events');
    }
}
