<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEventEventdetailsTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('event__eventdetails_translations', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            // Your translatable fields

            $table->integer('eventdetails_id')->unsigned();
            $table->string('locale')->index();
            $table->unique(['eventdetails_id', 'locale']);
            $table->foreign('eventdetails_id')->references('id')->on('event__eventdetails')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('event__eventdetails_translations', function (Blueprint $table) {
            $table->dropForeign(['eventdetails_id']);
        });
        Schema::dropIfExists('event__eventdetails_translations');
    }
}
