<?php

namespace Modules\Event\Entities;

use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class Event extends Model
{
    use Translatable;

    protected $table = 'event__events';
    public $translatedAttributes = [];
    protected $fillable = ['name','req_volunteer','place','latitude','longitude','event_date','event_time','price','short_desc','description','image11','image12','image13','image14','status','location_id','cat_id','manager_id','todate','totime','hours','address'];

    public function category()
    {
        return $this->belongsTo("Modules\Category\Entities\Category","cat_id");
    }

    public function location()
    {
        return $this->belongsTo("Modules\Location\Entities\Location","location_id");
    }

    public function manager()
    {
        return $this->belongsTo("Modules\Userlist\Entities\Manager","manager_id");
    }

}
