<?php

namespace Modules\Event\Events\Handlers;

use Maatwebsite\Sidebar\Group;
use Maatwebsite\Sidebar\Item;
use Maatwebsite\Sidebar\Menu;
use Modules\Core\Events\BuildingSidebar;
use Modules\User\Contracts\Authentication;

class RegisterEventSidebar implements \Maatwebsite\Sidebar\SidebarExtender
{
    /**
     * @var Authentication
     */
    protected $auth;

    /**
     * @param Authentication $auth
     *
     * @internal param Guard $guard
     */
    public function __construct(Authentication $auth)
    {
        $this->auth = $auth;
    }

    public function handle(BuildingSidebar $sidebar)
    {
        $sidebar->add($this->extendWith($sidebar->getMenu()));
    }

    /**
     * @param Menu $menu
     * @return Menu
     */
    public function extendWith(Menu $menu)
    {
        $menu->group(trans('core::sidebar.content'), function (Group $group) {
            $group->item(trans('event::events.title.events'), function (Item $item) {
                $item->icon('fa fa-institution');
                $item->weight(10);
                $item->authorize(
                     /* append */
                );
                $item->item(trans('event::events.title.events'), function (Item $item) {
                    $item->icon('fa fa-institution');
                    $item->weight(0);
                    $item->append('admin.event.event.create');
                    $item->route('admin.event.event.index');
                    $item->authorize(
                        $this->auth->hasAccess('event.events.index')
                    );
                });
                $item->item(trans('Enrolls'), function (Item $item) {
                    $item->icon('fa fa-male');
                    $item->weight(0);
                    // $item->append('admin.event.eventdetails.create');
                    $item->route('admin.event.eventdetails.index');
                    $item->authorize(
                        $this->auth->hasAccess('event.eventdetails.index')
                    );
                });
// append


            });
        });

        return $menu;
    }
}
