<?php

namespace Modules\Event\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Event\Entities\Event;
use Modules\Event\Http\Requests\CreateEventRequest;
use Modules\Event\Http\Requests\UpdateEventRequest;
use Modules\Event\Repositories\EventRepository;
use Modules\Core\Http\Controllers\Admin\AdminBaseController;
use Modules\Location\Repositories\LocationRepository;
use Modules\Category\Repositories\CategoryRepository;
use Modules\Userlist\Repositories\ManagerRepository;
use Modules\Wallet\Repositories\TransactionRepository;
use Modules\Event\Repositories\EventdetailsRepository;
use DB;


class EventController extends AdminBaseController
{
    /**
     * @var EventRepository
     */
    private $event;

    public function __construct(EventRepository $event,LocationRepository $location,CategoryRepository $category,ManagerRepository $manager,TransactionRepository $transaction,EventdetailsRepository $eventdetails)
    {
        parent::__construct();

        $this->event = $event;
        $this->location = $location;
        $this->category = $category;
        $this->manager = $manager;
        $this->transaction = $transaction;
        $this->eventdetails = $eventdetails;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $events = $this->event->all();

        return view('event::admin.events.index', compact('events'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        $categories = $this->category->getByAttributes(['status' => 1]);
        $locations = $this->location->getByAttributes(['status' => 1]);
        return view('event::admin.events.create', compact('locations','categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CreateEventRequest $request
     * @return Response
     */
    public function store(CreateEventRequest $request)
    {
        if(isset($request->image1) && $request->image1){

              $file_name = $_FILES['image1']['name'];
              $file_size =$_FILES['image1']['size'];
              $file_tmp =$_FILES['image1']['tmp_name'];
              $file_type=$_FILES['image1']['type'];
              //$file_ext=strtolower(end(explode('.',$_FILES['prophoto']['name'])));
              
              $expensions= array("jpeg","jpg","png");

              $newfile = "assets/media/".time().$file_name;

              if($file_size > 2097152){
                 $errors[]='File size must be excately 2 MB';
              }
              
              if(empty($errors)==true){
                 move_uploaded_file($file_tmp,$newfile);
                 $request->merge(['image11' => $newfile]);
                 //echo "Success";
              }else{
                 //print_r($errors);
              }
            }

            if(isset($request->image2) && $request->image2){

              $file_name = $_FILES['image2']['name'];
              $file_size =$_FILES['image2']['size'];
              $file_tmp =$_FILES['image2']['tmp_name'];
              $file_type=$_FILES['image2']['type'];
              //$file_ext=strtolower(end(explode('.',$_FILES['prophoto']['name'])));
              
              $expensions= array("jpeg","jpg","png");

              $newfile = "assets/media/".time().$file_name;

              if($file_size > 2097152){
                 $errors[]='File size must be excately 2 MB';
              }
              
              if(empty($errors)==true){
                 move_uploaded_file($file_tmp,$newfile);
                 $request->merge(['image12' => $newfile]);
                 //echo "Success";
              }else{
                 //print_r($errors);
              }
            }

            if(isset($request->image3) && $request->image3){

              $file_name = $_FILES['image3']['name'];
              $file_size =$_FILES['image3']['size'];
              $file_tmp =$_FILES['image3']['tmp_name'];
              $file_type=$_FILES['image3']['type'];
              //$file_ext=strtolower(end(explode('.',$_FILES['prophoto']['name'])));
              
              $expensions= array("jpeg","jpg","png");

              $newfile = "assets/media/".time().$file_name;

              if($file_size > 2097152){
                 $errors[]='File size must be excately 2 MB';
              }
              
              if(empty($errors)==true){
                 move_uploaded_file($file_tmp,$newfile);
                 $request->merge(['image13' => $newfile]);
                 //echo "Success";
              }else{
                 //print_r($errors);
              }
            }

            if(isset($request->image4) && $request->image4){

              $file_name = $_FILES['image4']['name'];
              $file_size =$_FILES['image4']['size'];
              $file_tmp =$_FILES['image4']['tmp_name'];
              $file_type=$_FILES['image4']['type'];
              //$file_ext=strtolower(end(explode('.',$_FILES['prophoto']['name'])));
              
              $expensions= array("jpeg","jpg","png");

              $newfile = "assets/media/".time().$file_name;

              if($file_size > 2097152){
                 $errors[]='File size must be excately 2 MB';
              }
              
              if(empty($errors)==true){
                 move_uploaded_file($file_tmp,$newfile);
                 $request->merge(['image14' => $newfile]);
                 //echo "Success";
              }else{
                 //print_r($errors);
              }
            }

            // $data = json_encode($request->cat_id);
            // $request->merge(['cat_id' => $data]);


        $this->event->create($request->all());

        return redirect()->route('admin.event.event.index')
            ->withSuccess(trans('core::core.messages.resource created', ['name' => trans('event::events.title.events')]));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Event $event
     * @return Response
     */
    public function edit(Event $event)
    {
        $managers = $this->manager->getByAttributes(['status' => 1]);
        $categories = $this->category->getByAttributes(['status' => 1]);
        $locations = $this->location->getByAttributes(['status' => 1]);
        return view('event::admin.events.edit', compact('event','locations','categories','managers'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Event $event
     * @param  UpdateEventRequest $request
     * @return Response
     */
    public function update(Event $event, UpdateEventRequest $request)
    {
      if(isset($request->sss)){
        $ddd = DB::table('event__events')
                      ->where('id', $event->id)
                      ->update(['status' => $request->status]);
        $ddf = DB::table('event__eventdetails')
                      ->where('event_id', $event->id)
                      ->where('status', 2)
                      ->update(['status' => $request->status]);
        $eventdetails = $this->eventdetails->getByAttributes(['event_id' => $event->id]);
        foreach ($eventdetails as $value) {
          $fff = DB::table('wallet__transactions')->insert([
                      ['user_id' => $value->user_id, 'amount' => $value->price,'transaction_id' => $events->name, 'event_id' => $events->id, 'status' => 1]
                  ]);
        }
        return redirect()->route('admin.event.event.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('event::events.title.events')]));
      } elseif(isset($request->manager_id)) {
          if(isset($request->total) && !empty($request->total)) {
            $data = array('user_id' => $request->manager_id, 'amount' => $request->total, 'transaction_id' => $event->name, 'event_id' => $event->id, 'status' => 1, 'type' => 1);
            $this->transaction->create($data);
          }

          if(isset($request->amount) && !empty($request->amount)) {
            $data = array('user_id' => $request->manager_id, 'amount' => $request->amount, 'transaction_id' => $event->name, 'event_id' => $event->id, 'status' => 1, 'type' => 2);
            $this->transaction->create($data);
          }
          
          $this->event->update($event, $request->all());
          return redirect()->route('admin.event.event.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('event::events.title.events')]));
      } else {
        if(isset($request->image1) && $request->image1) {
          $file_name = $_FILES['image1']['name'];
          $file_size =$_FILES['image1']['size'];
          $file_tmp =$_FILES['image1']['tmp_name'];
          $file_type=$_FILES['image1']['type'];
          $expensions= array("jpeg","jpg","png");

          $newfile = "assets/media/".time().$file_name;

          if($file_size > 2097152){
            $errors[]='File size must be excately 2 MB';
          }
              
          if(empty($errors)==true){
              move_uploaded_file($file_tmp,$newfile);
              $request->merge(['image11' => $newfile]);
          }
        }

        if(isset($request->image2) && $request->image2) {
          $file_name = $_FILES['image2']['name'];
          $file_size =$_FILES['image2']['size'];
          $file_tmp =$_FILES['image2']['tmp_name'];
          $file_type=$_FILES['image2']['type'];
          $expensions= array("jpeg","jpg","png");

          $newfile = "assets/media/".time().$file_name;

          if($file_size > 2097152){
            $errors[]='File size must be excately 2 MB';
          }
              
          if(empty($errors)==true){
            move_uploaded_file($file_tmp,$newfile);
            $request->merge(['image12' => $newfile]);
          }
        }

        if(isset($request->image3) && $request->image3) {
          $file_name = $_FILES['image3']['name'];
          $file_size =$_FILES['image3']['size'];
          $file_tmp =$_FILES['image3']['tmp_name'];
          $file_type=$_FILES['image3']['type'];
          $expensions= array("jpeg","jpg","png");

          $newfile = "assets/media/".time().$file_name;

          if($file_size > 2097152){
            $errors[]='File size must be excately 2 MB';
          }
              
          if(empty($errors)==true){
            move_uploaded_file($file_tmp,$newfile);
            $request->merge(['image13' => $newfile]);
          }
        }

        if(isset($request->image4) && $request->image4){
          $file_name = $_FILES['image4']['name'];
          $file_size =$_FILES['image4']['size'];
          $file_tmp =$_FILES['image4']['tmp_name'];
          $file_type=$_FILES['image4']['type'];
          $expensions= array("jpeg","jpg","png");

          $newfile = "assets/media/".time().$file_name;

          if($file_size > 2097152) {
            $errors[]='File size must be excately 2 MB';
          }
              
          if(empty($errors)==true){
            move_uploaded_file($file_tmp,$newfile);
            $request->merge(['image14' => $newfile]);
          }
        }

        $this->event->update($event, $request->all());

        return redirect()->route('admin.event.event.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('event::events.title.events')]));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Event $event
     * @return Response
     */
    public function destroy(Event $event)
    {
        $this->event->destroy($event);

        return redirect()->route('admin.event.event.index')
            ->withSuccess(trans('core::core.messages.resource deleted', ['name' => trans('event::events.title.events')]));
    }
}
