<?php

namespace Modules\Event\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Event\Entities\Eventdetails;
use Modules\Event\Http\Requests\CreateEventdetailsRequest;
use Modules\Event\Http\Requests\UpdateEventdetailsRequest;
use Modules\Event\Repositories\EventdetailsRepository;
use Modules\Core\Http\Controllers\Admin\AdminBaseController;
use DB;

class EventdetailsController extends AdminBaseController
{
    /**
     * @var EventdetailsRepository
     */
    private $eventdetails;

    public function __construct(EventdetailsRepository $eventdetails)
    {
        parent::__construct();

        $this->eventdetails = $eventdetails;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        if(isset($_GET['id'])){
            $status_id = $_GET['id'];
            $eventdetails = $this->eventdetails->getByAttributes(['event_id' => $status_id]);
        }else{
            $eventdetails = $this->eventdetails->all();
        }

        // $eventdetails = $this->eventdetails->all();

        return view('event::admin.eventdetails.index', compact('eventdetails'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('event::admin.eventdetails.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CreateEventdetailsRequest $request
     * @return Response
     */
    public function store(CreateEventdetailsRequest $request)
    {
        $this->eventdetails->create($request->all());

        return redirect()->route('admin.event.eventdetails.index')
            ->withSuccess(trans('core::core.messages.resource created', ['name' => trans('event::eventdetails.title.eventdetails')]));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Eventdetails $eventdetails
     * @return Response
     */
    public function edit(Eventdetails $eventdetails)
    {
        return view('event::admin.eventdetails.edit', compact('eventdetails'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Eventdetails $eventdetails
     * @param  UpdateEventdetailsRequest $request
     * @return Response
     */
    public function update(Eventdetails $eventdetails, UpdateEventdetailsRequest $request)
    {

        if($request->status == 2){
            $user = DB::table('userlist__userlists')->where('user_id', '=', $eventdetails->user_id)->get();
            $phone = $user[0]->phone;

            $otp = rand ( 100000 , 999999);
            $text = "Your verification code for the event: " .$otp;
            $url = "https://control.msg91.com/api/sendhttp.php?authkey=235767A0wqpfo7UPaH5cd6b1cb&mobiles=".$phone."&message=".$text."&sender=HASHVA&route=4&country=91";
            $return = file($url);

            $request->merge(['ver_code' => $otp]);
            $events = DB::table('event__events')->where('id', '=', $eventdetails->event_id)->get();
            $rem_vol = $events[0]->req_volunteer-1;
            $alloted_vol1 = $events[0]->alloted_vol+1;
            $events = DB::table('event__events')
                    ->where('id', $eventdetails->event_id)
                    ->update(['req_volunteer' => $rem_vol,'alloted_vol' => $alloted_vol1]);
            $this->eventdetails->update($eventdetails, $request->all());
        }else{
            if($request->status == 0) {
                $this->eventdetails->destroy($eventdetails);
            } else {
                $this->eventdetails->update($eventdetails, $request->all());
            }
        }
        // $this->eventdetails->update($eventdetails, $request->all());

        return redirect()->route('admin.event.eventdetails.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('event::eventdetails.title.eventdetails')]));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Eventdetails $eventdetails
     * @return Response
     */
    public function destroy(Eventdetails $eventdetails)
    {
        $this->eventdetails->destroy($eventdetails);

        return redirect()->route('admin.event.eventdetails.index')
            ->withSuccess(trans('core::core.messages.resource deleted', ['name' => trans('event::eventdetails.title.eventdetails')]));
    }
}
