<?php

use Illuminate\Routing\Router;
/** @var Router $router */

$router->group(['prefix' =>'/event'], function (Router $router) {
    $router->bind('event', function ($id) {
        return app('Modules\Event\Repositories\EventRepository')->find($id);
    });
    $router->get('events', [
        'as' => 'admin.event.event.index',
        'uses' => 'EventController@index',
        'middleware' => 'can:event.events.index'
    ]);
    $router->get('events/create', [
        'as' => 'admin.event.event.create',
        'uses' => 'EventController@create',
        'middleware' => 'can:event.events.create'
    ]);
    $router->post('events', [
        'as' => 'admin.event.event.store',
        'uses' => 'EventController@store',
        'middleware' => 'can:event.events.create'
    ]);
    $router->get('events/{event}/edit', [
        'as' => 'admin.event.event.edit',
        'uses' => 'EventController@edit',
        'middleware' => 'can:event.events.edit'
    ]);
    $router->put('events/{event}', [
        'as' => 'admin.event.event.update',
        'uses' => 'EventController@update',
        'middleware' => 'can:event.events.edit'
    ]);
    $router->delete('events/{event}', [
        'as' => 'admin.event.event.destroy',
        'uses' => 'EventController@destroy',
        'middleware' => 'can:event.events.destroy'
    ]);
    $router->bind('eventdetails', function ($id) {
        return app('Modules\Event\Repositories\EventdetailsRepository')->find($id);
    });
    $router->get('eventdetails', [
        'as' => 'admin.event.eventdetails.index',
        'uses' => 'EventdetailsController@index',
        'middleware' => 'can:event.eventdetails.index'
    ]);
    $router->get('eventdetails/create', [
        'as' => 'admin.event.eventdetails.create',
        'uses' => 'EventdetailsController@create',
        'middleware' => 'can:event.eventdetails.create'
    ]);
    $router->post('eventdetails', [
        'as' => 'admin.event.eventdetails.store',
        'uses' => 'EventdetailsController@store',
        'middleware' => 'can:event.eventdetails.create'
    ]);
    $router->get('eventdetails/{eventdetails}/edit', [
        'as' => 'admin.event.eventdetails.edit',
        'uses' => 'EventdetailsController@edit',
        'middleware' => 'can:event.eventdetails.edit'
    ]);
    $router->put('eventdetails/{eventdetails}', [
        'as' => 'admin.event.eventdetails.update',
        'uses' => 'EventdetailsController@update',
        'middleware' => 'can:event.eventdetails.edit'
    ]);
    $router->delete('eventdetails/{eventdetails}', [
        'as' => 'admin.event.eventdetails.destroy',
        'uses' => 'EventdetailsController@destroy',
        'middleware' => 'can:event.eventdetails.destroy'
    ]);
// append


});
