<?php

namespace Modules\Event\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Core\Traits\CanPublishConfiguration;
use Modules\Core\Events\BuildingSidebar;
use Modules\Core\Events\LoadingBackendTranslations;
use Modules\Event\Events\Handlers\RegisterEventSidebar;

class EventServiceProvider extends ServiceProvider
{
    use CanPublishConfiguration;
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->registerBindings();
        $this->app['events']->listen(BuildingSidebar::class, RegisterEventSidebar::class);

        $this->app['events']->listen(LoadingBackendTranslations::class, function (LoadingBackendTranslations $event) {
            $event->load('events', array_dot(trans('event::events')));
            $event->load('eventdetails', array_dot(trans('event::eventdetails')));
            // append translations


        });
    }

    public function boot()
    {
        $this->publishConfig('event', 'permissions');

        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return array();
    }

    private function registerBindings()
    {
        $this->app->bind(
            'Modules\Event\Repositories\EventRepository',
            function () {
                $repository = new \Modules\Event\Repositories\Eloquent\EloquentEventRepository(new \Modules\Event\Entities\Event());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Event\Repositories\Cache\CacheEventDecorator($repository);
            }
        );
        $this->app->bind(
            'Modules\Event\Repositories\EventdetailsRepository',
            function () {
                $repository = new \Modules\Event\Repositories\Eloquent\EloquentEventdetailsRepository(new \Modules\Event\Entities\Eventdetails());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Event\Repositories\Cache\CacheEventdetailsDecorator($repository);
            }
        );
// add bindings


    }
}
