@extends('layouts.master')

@section('content-header')
    <h1>
        {{ trans('User Enrolls') }}
    </h1>
    <ol class="breadcrumb">
        <li><a href="{{ route('dashboard.index') }}"><i class="fa fa-dashboard"></i> {{ trans('core::core.breadcrumb.home') }}</a></li>
        <li class="active">{{ trans('User Enrolls') }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-xs-12">
            <!-- <div class="row">
                <div class="btn-group pull-right" style="margin: 0 15px 15px 0;">
                    <a href="{{ route('admin.event.eventdetails.create') }}" class="btn btn-primary btn-flat" style="padding: 4px 10px;">
                        <i class="fa fa-pencil"></i> {{ trans('event::eventdetails.button.create eventdetails') }}
                    </a>
                </div>
            </div> -->
            <div class="box box-primary">
                <div class="box-header">
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="data-table table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Event</th>
                                <th>Customer Details</th>
                                <th>Status</th>
                                <th>{{ trans('core::core.table.created at') }}</th>
                                <th data-sortable="false">{{ trans('core::core.table.actions') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if (isset($eventdetails)): ?>
                            <?php foreach ($eventdetails as $eventdetails): ?>
                            <tr>
                                <td>{{ $eventdetails->id }}</td>
                                <?php $location = DB::table('location__locations')->where('id', '=', $eventdetails->event['location_id'])->get(); ?>

                                <td>{{ $eventdetails->event['name'] }}<br>{{ $location[0]->name }}</td>
                                <td>{{ $eventdetails->user['first_name'] }} {{ $eventdetails->user['last_name'] }} <br>
                                    {{ $eventdetails->user['phone'] }}</td>
                                <td> 
                                    <?php if ($eventdetails->status == 1) { ?>
                                       <b style="color: orange;">New</b>
                                    <?php }elseif ($eventdetails->status == 2) { ?>
                                       <b style="color: green;">Enrolled</b>
                                    <?php } elseif($eventdetails->status == 3) { ?>
                                        <b style="color: blue;">Completed</b>
                                    <?php } elseif($eventdetails->status == 4) { ?>
                                        <b style="color: red;">Rejected</b>
                                    <?php } else { ?>
                                        <b style="color: red;">Inactive</b>
                                    <?php } ?>
                                 </td>
                                <td>
                                    <!-- <a href="{{ route('admin.event.eventdetails.edit', [$eventdetails->id]) }}"> -->
                                        {{ $eventdetails->created_at }}
                                    <!-- </a> -->
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.event.eventdetails.edit', [$eventdetails->id]) }}" class="btn btn-default btn-flat"><i class="fa fa-pencil"></i></a>
                                        <button class="btn btn-danger btn-flat" data-toggle="modal" data-target="#modal-delete-confirmation" data-action-target="{{ route('admin.event.eventdetails.destroy', [$eventdetails->id]) }}"><i class="fa fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                            <!-- <tfoot>
                            <tr>
                                <th>{{ trans('core::core.table.created at') }}</th>
                                <th>{{ trans('core::core.table.actions') }}</th>
                            </tr>
                            </tfoot> -->
                        </table>
                        <!-- /.box-body -->
                    </div>
                </div>
                <!-- /.box -->
            </div>
        </div>
    </div>
    @include('core::partials.delete-modal')
@stop

@section('footer')
    <a data-toggle="modal" data-target="#keyboardShortcutsModal"><i class="fa fa-keyboard-o"></i></a> &nbsp;
@stop
@section('shortcuts')
    <dl class="dl-horizontal">
        <dt><code>c</code></dt>
        <dd>{{ trans('event::eventdetails.title.create eventdetails') }}</dd>
    </dl>
@stop

@push('js-stack')
    <script type="text/javascript">
        $( document ).ready(function() {
            $(document).keypressAction({
                actions: [
                    { key: 'c', route: "<?= route('admin.event.eventdetails.create') ?>" }
                ]
            });
        });
    </script>
    <?php $locale = locale(); ?>
    <script type="text/javascript">
        $(function () {
            $('.data-table').dataTable({
                "paginate": true,
                "lengthChange": true,
                "filter": true,
                "sort": true,
                "info": true,
                "autoWidth": true,
                "order": [[ 0, "desc" ]],
                "language": {
                    "url": '<?php echo Module::asset("core:js/vendor/datatables/{$locale}.json") ?>'
                }
            });
        });
    </script>
@endpush
