@extends('layouts.master')

@section('content-header')
    <h1>
        {{ trans('event::events.title.events') }}
    </h1>
    <ol class="breadcrumb">
        <li><a href="{{ route('dashboard.index') }}"><i class="fa fa-dashboard"></i> {{ trans('core::core.breadcrumb.home') }}</a></li>
        <li class="active">{{ trans('event::events.title.events') }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="row">
                <div class="btn-group pull-right" style="margin: 0 15px 15px 0;">
                    <a href="{{ route('admin.event.event.create') }}" class="btn btn-primary btn-flat" style="padding: 4px 10px;">
                        <i class="fa fa-pencil"></i> {{ trans('event::events.button.create event') }}
                    </a>
                </div>
            </div>
            <div class="box box-primary">
                <div class="box-header">
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="data-table table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Category</th>
                                <th>Location</th>
                                <th>Name</th>
                                <th>Details</th>
                                <th>Required Resources</th>
                                <!-- <th>Short Description</th>
                                <th>Description</th>
                                <th>Image</th> -->
                                <th>status</th>
                                <th>Manager Assigned</th>
                                <th>{{ trans('core::core.table.created at') }}</th>
                                <th data-sortable="false">{{ trans('core::core.table.actions') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if (isset($events)): ?>
                            <?php foreach ($events as $event): ?>
                            <tr>
                                <td>{{ $event->id }}</td>
                                <td>
                                    
                                    {{ $event->category['name'] }}
                                </td>
                                <td>{{ $event->location['name'] }}</td>
                                <td>{{ $event->name }}</td>
                                <td><b>From :</b> {{ $event->event_date }} <br> {{ $event->event_time }}<br><b>To :</b> {{ $event->todate }} <br> {{ $event->totime }}</td>
                                <td>{{ $event->req_volunteer }}</td>

                                <td> 
                                    <?php if ($event->status == 1) { ?>
                                       <b style="color: blue;">Active</b>
                                    <?php }elseif ($event->status == 0) { ?>
                                       <b style="color: green;">Active</b>
                                    <?php } else { ?>
                                        <b style="color: green;">Completed</b>
                                    <?php } ?>
                                 </td>
                                 <td>
                                    <?php if(isset($event->manager_id) && !empty($event->manager_id)) { ?>
                                    <?php $user = DB::table('userlist__managers')->where('user_id', '=', $event->manager_id)->get(); ?>
                                            <?php if(isset($user[0]->first_name)) { ?>
                                            {{ $user[0]->first_name }} {{ $user[0]->last_name }} <br>{{ $user[0]->phone }}
                                        <?php } }?>
                                </td>
                                <td>
                                    {{ $event->created_at }}
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.event.event.edit', [$event->id]) }}?id=1" class="btn btn-default btn-flat"><i class="fa fa-pencil"></i></a>
                                        <br>
                                        <?php if(isset($event->manager_id)) { ?>
                                             <a href="{{ route('admin.event.event.edit', [$event->id]) }}?id=2" class="btn btn-default btn-flat">Re Assign</a>
                                        <?php } else { ?>
                                            <a href="{{ route('admin.event.event.edit', [$event->id]) }}?id=2" class="btn btn-default btn-flat">Assign</a>
                                        <?php } ?><br>
                                            <a href="{{ route('admin.event.eventdetails.index') }}?id={{ $event->id }}" class="btn btn-default btn-flat">Enrolls</a><br>
                                            <?php if($event->status == 1 || $event->status == 2){ ?>
                                                <a href="{{ route('admin.event.event.edit', [$event->id]) }}?id=3" class="btn btn-default btn-flat">Status</a><br>
                                            <?php }else{

                                            } ?>
                                        <button class="btn btn-danger btn-flat" data-toggle="modal" data-target="#modal-delete-confirmation" data-action-target="{{ route('admin.event.event.destroy', [$event->id]) }}"><i class="fa fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                            <!-- <tfoot>
                            <tr>
                                <th>{{ trans('core::core.table.created at') }}</th>
                                <th>{{ trans('core::core.table.actions') }}</th>
                            </tr>
                            </tfoot> -->
                        </table>
                        <!-- /.box-body -->
                    </div>
                </div>
                <!-- /.box -->
            </div>
        </div>
    </div>
    @include('core::partials.delete-modal')
@stop

@section('footer')
    <a data-toggle="modal" data-target="#keyboardShortcutsModal"><i class="fa fa-keyboard-o"></i></a> &nbsp;
@stop
@section('shortcuts')
    <dl class="dl-horizontal">
        <dt><code>c</code></dt>
        <dd>{{ trans('event::events.title.create event') }}</dd>
    </dl>
@stop

@push('js-stack')
    <script type="text/javascript">
        $( document ).ready(function() {
            $(document).keypressAction({
                actions: [
                    { key: 'c', route: "<?= route('admin.event.event.create') ?>" }
                ]
            });
        });
    </script>
    <?php $locale = locale(); ?>
    <script type="text/javascript">
        $(function () {
            $('.data-table').dataTable({
                "paginate": true,
                "lengthChange": true,
                "filter": true,
                "sort": true,
                "info": true,
                "autoWidth": true,
                "order": [[ 0, "desc" ]],
                "language": {
                    "url": '<?php echo Module::asset("core:js/vendor/datatables/{$locale}.json") ?>'
                }
            });
        });
    </script>
@endpush
