<?php

namespace Modules\Location\Events\Handlers;

use Maatwebsite\Sidebar\Group;
use Maatwebsite\Sidebar\Item;
use Maatwebsite\Sidebar\Menu;
use Modules\Core\Events\BuildingSidebar;
use Modules\User\Contracts\Authentication;

class RegisterLocationSidebar implements \Maatwebsite\Sidebar\SidebarExtender
{
    /**
     * @var Authentication
     */
    protected $auth;

    /**
     * @param Authentication $auth
     *
     * @internal param Guard $guard
     */
    public function __construct(Authentication $auth)
    {
        $this->auth = $auth;
    }

    public function handle(BuildingSidebar $sidebar)
    {
        $sidebar->add($this->extendWith($sidebar->getMenu()));
    }

    /**
     * @param Menu $menu
     * @return Menu
     */
    public function extendWith(Menu $menu)
    {
        $menu->group(trans('core::sidebar.content'), function (Group $group) {
            $group->item(trans('City'), function (Item $item) {
                // $item->icon('fa fa-copy');
                // $item->weight(10);
                // $item->authorize(
                //      /* append */
                // );
                // $item->item(trans('City'), function (Item $item) {
                    $item->icon('fa fa-arrows');
                    $item->weight(4);
                    $item->append('admin.location.location.create');
                    $item->route('admin.location.location.index');
                    $item->authorize(
                        $this->auth->hasAccess('location.locations.index')
                    );
                // });
                // $item->item(trans('location::cities.title.cities'), function (Item $item) {
                //     $item->icon('fa fa-copy');
                //     $item->weight(0);
                //     $item->append('admin.location.city.create');
                //     $item->route('admin.location.city.index');
                //     $item->authorize(
                //         $this->auth->hasAccess('location.cities.index')
                //     );
                // });
// append


            });
        });

        return $menu;
    }
}
