<?php

namespace Modules\Location\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Location\Entities\city;
use Modules\Location\Http\Requests\CreatecityRequest;
use Modules\Location\Http\Requests\UpdatecityRequest;
use Modules\Location\Repositories\cityRepository;
use Modules\Core\Http\Controllers\Admin\AdminBaseController;

class cityController extends AdminBaseController
{
    /**
     * @var cityRepository
     */
    private $city;

    public function __construct(cityRepository $city)
    {
        parent::__construct();

        $this->city = $city;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $cities = $this->city->all();

        return view('location::admin.cities.index', compact('cities'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('location::admin.cities.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CreatecityRequest $request
     * @return Response
     */
    public function store(CreatecityRequest $request)
    {
        $this->city->create($request->all());

        return redirect()->route('admin.location.city.index')
            ->withSuccess(trans('core::core.messages.resource created', ['name' => trans('location::cities.title.cities')]));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  city $city
     * @return Response
     */
    public function edit(city $city)
    {
        return view('location::admin.cities.edit', compact('city'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  city $city
     * @param  UpdatecityRequest $request
     * @return Response
     */
    public function update(city $city, UpdatecityRequest $request)
    {
        $this->city->update($city, $request->all());

        return redirect()->route('admin.location.city.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('location::cities.title.cities')]));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  city $city
     * @return Response
     */
    public function destroy(city $city)
    {
        $this->city->destroy($city);

        return redirect()->route('admin.location.city.index')
            ->withSuccess(trans('core::core.messages.resource deleted', ['name' => trans('location::cities.title.cities')]));
    }
}
