<?php

namespace Modules\Location\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Core\Traits\CanPublishConfiguration;
use Modules\Core\Events\BuildingSidebar;
use Modules\Core\Events\LoadingBackendTranslations;
use Modules\Location\Events\Handlers\RegisterLocationSidebar;

class LocationServiceProvider extends ServiceProvider
{
    use CanPublishConfiguration;
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->registerBindings();
        $this->app['events']->listen(BuildingSidebar::class, RegisterLocationSidebar::class);

        $this->app['events']->listen(LoadingBackendTranslations::class, function (LoadingBackendTranslations $event) {
            $event->load('locations', array_dot(trans('location::locations')));
            $event->load('cities', array_dot(trans('location::cities')));
            // append translations


        });
    }

    public function boot()
    {
        $this->publishConfig('location', 'permissions');

        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return array();
    }

    private function registerBindings()
    {
        $this->app->bind(
            'Modules\Location\Repositories\LocationRepository',
            function () {
                $repository = new \Modules\Location\Repositories\Eloquent\EloquentLocationRepository(new \Modules\Location\Entities\Location());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Location\Repositories\Cache\CacheLocationDecorator($repository);
            }
        );
        $this->app->bind(
            'Modules\Location\Repositories\cityRepository',
            function () {
                $repository = new \Modules\Location\Repositories\Eloquent\EloquentcityRepository(new \Modules\Location\Entities\city());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Location\Repositories\Cache\CachecityDecorator($repository);
            }
        );
// add bindings


    }
}
