<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserlistUserlistTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('userlist__userlist_translations', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            // Your translatable fields

            $table->integer('userlist_id')->unsigned();
            $table->string('locale')->index();
            $table->unique(['userlist_id', 'locale']);
            $table->foreign('userlist_id')->references('id')->on('userlist__userlists')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('userlist__userlist_translations', function (Blueprint $table) {
            $table->dropForeign(['userlist_id']);
        });
        Schema::dropIfExists('userlist__userlist_translations');
    }
}
