<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserlistLatlongTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('userlist__latlong_translations', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            // Your translatable fields

            $table->integer('latlong_id')->unsigned();
            $table->string('locale')->index();
            $table->unique(['latlong_id', 'locale']);
            $table->foreign('latlong_id')->references('id')->on('userlist__latlongs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('userlist__latlong_translations', function (Blueprint $table) {
            $table->dropForeign(['latlong_id']);
        });
        Schema::dropIfExists('userlist__latlong_translations');
    }
}
