<?php

namespace Modules\Userlist\Entities;

use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class Manager extends Model
{
    use Translatable;

    protected $table = 'userlist__managers';
    public $translatedAttributes = [];
    protected $fillable = ['user_id','first_name','last_name','phone','email','place','status', 'company_name', 'gst', 'alternate_phone', 'alternate_email','photo'];

    public function user()
	{
	    return $this->belongsTo("Modules\User\Entities\Sentinel\User","user_id");
	}
}
