<?php

namespace Modules\Userlist\Entities;

use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    use Translatable;

    protected $table = 'userlist__reviews';
    public $translatedAttributes = [];
    protected $fillable = [
    	'user_id','manager_id','rating','comment','status'
    ];

    public function user() {
	    return $this->belongsTo("Modules\User\Entities\Sentinel\User","user_id");
	}

	public function manager() {
	    return $this->belongsTo("Modules\User\Entities\Sentinel\User","manager_id");
	}
}
