<?php

namespace Modules\Userlist\Events\Handlers;

use Maatwebsite\Sidebar\Group;
use Maatwebsite\Sidebar\Item;
use Maatwebsite\Sidebar\Menu;
use Modules\Core\Events\BuildingSidebar;
use Modules\User\Contracts\Authentication;

class RegisterUserlistSidebar implements \Maatwebsite\Sidebar\SidebarExtender
{
    /**
     * @var Authentication
     */
    protected $auth;

    /**
     * @param Authentication $auth
     *
     * @internal param Guard $guard
     */
    public function __construct(Authentication $auth)
    {
        $this->auth = $auth;
    }

    public function handle(BuildingSidebar $sidebar)
    {
        $sidebar->add($this->extendWith($sidebar->getMenu()));
    }

    /**
     * @param Menu $menu
     * @return Menu
     */
    public function extendWith(Menu $menu)
    {
        $menu->group(trans('core::sidebar.content'), function (Group $group) {
            $group->item(trans('userlist::userlists.title.userlists'), function (Item $item) {
                $item->icon('fa fa-users');
                $item->weight(10);
                $item->authorize(
                     /* append */
                );
                $item->item(trans('userlist::userlists.title.userlists'), function (Item $item) {
                    $item->icon('fa fa-users');
                    $item->weight(0);
                    // $item->append('admin.userlist.userlist.create');
                    $item->route('admin.userlist.userlist.index');
                    $item->authorize(
                        $this->auth->hasAccess('userlist.userlists.index')
                    );
                });
                $item->item(trans('userlist::managers.title.managers'), function (Item $item) {
                    $item->icon('fa fa-user-secret');
                    $item->weight(0);
                    $item->append('admin.userlist.manager.create');
                    $item->route('admin.userlist.manager.index');
                    $item->authorize(
                        $this->auth->hasAccess('userlist.managers.index')
                    );
                });
                $item->item(trans('userlist::reviews.title.reviews'), function (Item $item) {
                    $item->icon('fa fa-copy');
                    $item->weight(0);
                    $item->append('admin.userlist.review.create');
                    $item->route('admin.userlist.review.index');
                    $item->authorize(
                        $this->auth->hasAccess('userlist.reviews.index')
                    );
                });
                $item->item(trans('userlist::latlongs.title.latlongs'), function (Item $item) {
                    $item->icon('fa fa-copy');
                    $item->weight(0);
                    $item->append('admin.userlist.latlong.create');
                    $item->route('admin.userlist.latlong.index');
                    $item->authorize(
                        $this->auth->hasAccess('userlist.latlongs.index')
                    );
                });
// append




            });
        });

        return $menu;
    }
}
