<?php

namespace Modules\Userlist\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Userlist\Entities\Latlong;
use Modules\Userlist\Http\Requests\CreateLatlongRequest;
use Modules\Userlist\Http\Requests\UpdateLatlongRequest;
use Modules\Userlist\Repositories\LatlongRepository;
use Modules\Core\Http\Controllers\Admin\AdminBaseController;

class LatlongController extends AdminBaseController
{
    /**
     * @var LatlongRepository
     */
    private $latlong;

    public function __construct(LatlongRepository $latlong)
    {
        parent::__construct();

        $this->latlong = $latlong;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        //$latlongs = $this->latlong->all();

        return view('userlist::admin.latlongs.index', compact(''));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('userlist::admin.latlongs.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CreateLatlongRequest $request
     * @return Response
     */
    public function store(CreateLatlongRequest $request)
    {
        $this->latlong->create($request->all());

        return redirect()->route('admin.userlist.latlong.index')
            ->withSuccess(trans('core::core.messages.resource created', ['name' => trans('userlist::latlongs.title.latlongs')]));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Latlong $latlong
     * @return Response
     */
    public function edit(Latlong $latlong)
    {
        return view('userlist::admin.latlongs.edit', compact('latlong'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Latlong $latlong
     * @param  UpdateLatlongRequest $request
     * @return Response
     */
    public function update(Latlong $latlong, UpdateLatlongRequest $request)
    {
        $this->latlong->update($latlong, $request->all());

        return redirect()->route('admin.userlist.latlong.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('userlist::latlongs.title.latlongs')]));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Latlong $latlong
     * @return Response
     */
    public function destroy(Latlong $latlong)
    {
        $this->latlong->destroy($latlong);

        return redirect()->route('admin.userlist.latlong.index')
            ->withSuccess(trans('core::core.messages.resource deleted', ['name' => trans('userlist::latlongs.title.latlongs')]));
    }
}
