<?php

namespace Modules\Userlist\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Userlist\Entities\Manager;
use Modules\Userlist\Http\Requests\CreateManagerRequest;
use Modules\Userlist\Http\Requests\UpdateManagerRequest;
use Modules\Userlist\Repositories\ManagerRepository;
use Modules\Core\Http\Controllers\Admin\AdminBaseController;
use Modules\User\Repositories\UserRepository;
use Modules\User\Repositories\RoleRepository;
use DB;

class ManagerController extends AdminBaseController
{
    /**
     * @var ManagerRepository
     */
    private $manager;

    public function __construct(ManagerRepository $manager,UserRepository $user,RoleRepository $role)
    {
        parent::__construct();

        $this->manager = $manager;
        $this->user = $user;
        $this->role = $role;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $managers = $this->manager->all();

        return view('userlist::admin.managers.index', compact('managers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('userlist::admin.managers.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CreateManagerRequest $request
     * @return Response
     */
    public function store(CreateManagerRequest $request)
    {
        $role_type = $this->role->findByName(['name' => 'manager']);
        if(isset($role_type->name)){
            $request->merge(array('role' => $role_type->name));
            $request->merge(['password' => $request->phone,'role' => $role_type->name]);
            $user_detail = $this->user->createWithRoles($request->all(),$role_type->id,true);
            $ddd = DB::table('users')
                  ->where('id', $user_detail->id)
                  ->update(['role' => 'manager']);
            $fff = DB::table('wallet__wallets')->insert([
                      ['user_id' => $user_detail->id, 'amount' => 0]
                  ]);

            $request->merge(array('user_id' => $user_detail->id));
            $this->manager->create($request->all());

            return redirect()->route('admin.userlist.manager.index')
            ->withSuccess(trans('core::core.messages.resource created', ['name' => trans('userlist::managers.title.managers')]));

        } else {
          return redirect()->route('admin.userlist.manager.index')
            ->withError(trans('Role Not Defined', ['name' => trans('userlist::managers.title.managers')]));
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Manager $manager
     * @return Response
     */
    public function edit(Manager $manager)
    {
        return view('userlist::admin.managers.edit', compact('manager'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Manager $manager
     * @param  UpdateManagerRequest $request
     * @return Response
     */
    public function update(Manager $manager, UpdateManagerRequest $request)
    {
        $this->user->update($manager->user, $request->all());
        $this->manager->update($manager, $request->all());

        return redirect()->route('admin.userlist.manager.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('userlist::managers.title.managers')]));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Manager $manager
     * @return Response
     */
    public function destroy(Manager $manager)
    {
        $this->manager->destroy($manager);

        return redirect()->route('admin.userlist.manager.index')
            ->withSuccess(trans('core::core.messages.resource deleted', ['name' => trans('userlist::managers.title.managers')]));
    }
}
