<?php

namespace Modules\Userlist\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Userlist\Entities\Userlist;
use Modules\Userlist\Http\Requests\CreateUserlistRequest;
use Modules\Userlist\Http\Requests\UpdateUserlistRequest;
use Modules\Userlist\Repositories\UserlistRepository;
use Modules\Core\Http\Controllers\Admin\AdminBaseController;
use Modules\User\Repositories\UserRepository;

class UserlistController extends AdminBaseController
{
    /**
     * @var UserlistRepository
     */
    private $userlist;

    public function __construct(UserlistRepository $userlist, UserRepository $user)
    {
        parent::__construct();

        $this->userlist = $userlist;
        $this->user = $user;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $userlists = $this->userlist->getByAttributes([],'id','desc');

        return view('userlist::admin.userlists.index', compact('userlists'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('userlist::admin.userlists.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CreateUserlistRequest $request
     * @return Response
     */
    public function store(CreateUserlistRequest $request)
    {
        $this->userlist->create($request->all());

        return redirect()->route('admin.userlist.userlist.index')
            ->withSuccess(trans('core::core.messages.resource created', ['name' => trans('userlist::userlists.title.userlists')]));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Userlist $userlist
     * @return Response
     */
    public function edit(Userlist $userlist)
    {
        return view('userlist::admin.userlists.edit', compact('userlist'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Userlist $userlist
     * @param  UpdateUserlistRequest $request
     * @return Response
     */
    public function update(Userlist $userlist, UpdateUserlistRequest $request)
    {
        $this->user->update($userlist->user, $request->all());
        $this->userlist->update($userlist, $request->all());

        return redirect()->route('admin.userlist.userlist.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('userlist::userlists.title.userlists')]));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Userlist $userlist
     * @return Response
     */
    public function destroy(Userlist $userlist)
    {
        $this->userlist->destroy($userlist);

        return redirect()->route('admin.userlist.userlist.index')
            ->withSuccess(trans('core::core.messages.resource deleted', ['name' => trans('userlist::userlists.title.userlists')]));
    }
}
