<?php

use Illuminate\Routing\Router;
/** @var Router $router */

$router->group(['prefix' =>'/userlist'], function (Router $router) {
    $router->bind('userlist', function ($id) {
        return app('Modules\Userlist\Repositories\UserlistRepository')->find($id);
    });
    $router->get('userlists', [
        'as' => 'admin.userlist.userlist.index',
        'uses' => 'UserlistController@index',
        'middleware' => 'can:userlist.userlists.index'
    ]);
    $router->get('userlists/create', [
        'as' => 'admin.userlist.userlist.create',
        'uses' => 'UserlistController@create',
        'middleware' => 'can:userlist.userlists.create'
    ]);
    $router->post('userlists', [
        'as' => 'admin.userlist.userlist.store',
        'uses' => 'UserlistController@store',
        'middleware' => 'can:userlist.userlists.create'
    ]);
    $router->get('userlists/{userlist}/edit', [
        'as' => 'admin.userlist.userlist.edit',
        'uses' => 'UserlistController@edit',
        'middleware' => 'can:userlist.userlists.edit'
    ]);
    $router->put('userlists/{userlist}', [
        'as' => 'admin.userlist.userlist.update',
        'uses' => 'UserlistController@update',
        'middleware' => 'can:userlist.userlists.edit'
    ]);
    $router->delete('userlists/{userlist}', [
        'as' => 'admin.userlist.userlist.destroy',
        'uses' => 'UserlistController@destroy',
        'middleware' => 'can:userlist.userlists.destroy'
    ]);
    $router->bind('manager', function ($id) {
        return app('Modules\Userlist\Repositories\ManagerRepository')->find($id);
    });
    $router->get('managers', [
        'as' => 'admin.userlist.manager.index',
        'uses' => 'ManagerController@index',
        'middleware' => 'can:userlist.managers.index'
    ]);
    $router->get('managers/create', [
        'as' => 'admin.userlist.manager.create',
        'uses' => 'ManagerController@create',
        'middleware' => 'can:userlist.managers.create'
    ]);
    $router->post('managers', [
        'as' => 'admin.userlist.manager.store',
        'uses' => 'ManagerController@store',
        'middleware' => 'can:userlist.managers.create'
    ]);
    $router->get('managers/{manager}/edit', [
        'as' => 'admin.userlist.manager.edit',
        'uses' => 'ManagerController@edit',
        'middleware' => 'can:userlist.managers.edit'
    ]);
    $router->put('managers/{manager}', [
        'as' => 'admin.userlist.manager.update',
        'uses' => 'ManagerController@update',
        'middleware' => 'can:userlist.managers.edit'
    ]);
    $router->delete('managers/{manager}', [
        'as' => 'admin.userlist.manager.destroy',
        'uses' => 'ManagerController@destroy',
        'middleware' => 'can:userlist.managers.destroy'
    ]);
    $router->bind('review', function ($id) {
        return app('Modules\Userlist\Repositories\ReviewRepository')->find($id);
    });
    $router->get('reviews', [
        'as' => 'admin.userlist.review.index',
        'uses' => 'ReviewController@index',
        'middleware' => 'can:userlist.reviews.index'
    ]);
    $router->get('reviews/create', [
        'as' => 'admin.userlist.review.create',
        'uses' => 'ReviewController@create',
        'middleware' => 'can:userlist.reviews.create'
    ]);
    $router->post('reviews', [
        'as' => 'admin.userlist.review.store',
        'uses' => 'ReviewController@store',
        'middleware' => 'can:userlist.reviews.create'
    ]);
    $router->get('reviews/{review}/edit', [
        'as' => 'admin.userlist.review.edit',
        'uses' => 'ReviewController@edit',
        'middleware' => 'can:userlist.reviews.edit'
    ]);
    $router->put('reviews/{review}', [
        'as' => 'admin.userlist.review.update',
        'uses' => 'ReviewController@update',
        'middleware' => 'can:userlist.reviews.edit'
    ]);
    $router->delete('reviews/{review}', [
        'as' => 'admin.userlist.review.destroy',
        'uses' => 'ReviewController@destroy',
        'middleware' => 'can:userlist.reviews.destroy'
    ]);
    $router->bind('latlong', function ($id) {
        return app('Modules\Userlist\Repositories\LatlongRepository')->find($id);
    });
    $router->get('latlongs', [
        'as' => 'admin.userlist.latlong.index',
        'uses' => 'LatlongController@index',
        'middleware' => 'can:userlist.latlongs.index'
    ]);
    $router->get('latlongs/create', [
        'as' => 'admin.userlist.latlong.create',
        'uses' => 'LatlongController@create',
        'middleware' => 'can:userlist.latlongs.create'
    ]);
    $router->post('latlongs', [
        'as' => 'admin.userlist.latlong.store',
        'uses' => 'LatlongController@store',
        'middleware' => 'can:userlist.latlongs.create'
    ]);
    $router->get('latlongs/{latlong}/edit', [
        'as' => 'admin.userlist.latlong.edit',
        'uses' => 'LatlongController@edit',
        'middleware' => 'can:userlist.latlongs.edit'
    ]);
    $router->put('latlongs/{latlong}', [
        'as' => 'admin.userlist.latlong.update',
        'uses' => 'LatlongController@update',
        'middleware' => 'can:userlist.latlongs.edit'
    ]);
    $router->delete('latlongs/{latlong}', [
        'as' => 'admin.userlist.latlong.destroy',
        'uses' => 'LatlongController@destroy',
        'middleware' => 'can:userlist.latlongs.destroy'
    ]);
// append




});
