<?php

namespace Modules\Userlist\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Core\Traits\CanPublishConfiguration;
use Modules\Core\Events\BuildingSidebar;
use Modules\Core\Events\LoadingBackendTranslations;
use Modules\Userlist\Events\Handlers\RegisterUserlistSidebar;

class UserlistServiceProvider extends ServiceProvider
{
    use CanPublishConfiguration;
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->registerBindings();
        $this->app['events']->listen(BuildingSidebar::class, RegisterUserlistSidebar::class);

        $this->app['events']->listen(LoadingBackendTranslations::class, function (LoadingBackendTranslations $event) {
            $event->load('userlists', array_dot(trans('userlist::userlists')));
            $event->load('managers', array_dot(trans('userlist::managers')));
            $event->load('reviews', array_dot(trans('userlist::reviews')));
            $event->load('latlongs', array_dot(trans('userlist::latlongs')));
            // append translations




        });
    }

    public function boot()
    {
        $this->publishConfig('userlist', 'permissions');

        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return array();
    }

    private function registerBindings()
    {
        $this->app->bind(
            'Modules\Userlist\Repositories\UserlistRepository',
            function () {
                $repository = new \Modules\Userlist\Repositories\Eloquent\EloquentUserlistRepository(new \Modules\Userlist\Entities\Userlist());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Userlist\Repositories\Cache\CacheUserlistDecorator($repository);
            }
        );
        $this->app->bind(
            'Modules\Userlist\Repositories\ManagerRepository',
            function () {
                $repository = new \Modules\Userlist\Repositories\Eloquent\EloquentManagerRepository(new \Modules\Userlist\Entities\Manager());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Userlist\Repositories\Cache\CacheManagerDecorator($repository);
            }
        );
        $this->app->bind(
            'Modules\Userlist\Repositories\ReviewRepository',
            function () {
                $repository = new \Modules\Userlist\Repositories\Eloquent\EloquentReviewRepository(new \Modules\Userlist\Entities\Review());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Userlist\Repositories\Cache\CacheReviewDecorator($repository);
            }
        );
        $this->app->bind(
            'Modules\Userlist\Repositories\LatlongRepository',
            function () {
                $repository = new \Modules\Userlist\Repositories\Eloquent\EloquentLatlongRepository(new \Modules\Userlist\Entities\Latlong());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Userlist\Repositories\Cache\CacheLatlongDecorator($repository);
            }
        );
// add bindings




    }
}
