@extends('layouts.master')

@section('content-header')
    <h1>
        {{ trans('userlist::userlists.title.userlists') }}
    </h1>
    <ol class="breadcrumb">
        <li><a href="{{ route('dashboard.index') }}"><i class="fa fa-dashboard"></i> {{ trans('core::core.breadcrumb.home') }}</a></li>
        <li class="active">{{ trans('userlist::userlists.title.userlists') }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-xs-12">
            <!-- <div class="row">
                <div class="btn-group pull-right" style="margin: 0 15px 15px 0;">
                    <a href="{{ route('admin.userlist.userlist.create') }}" class="btn btn-primary btn-flat" style="padding: 4px 10px;">
                        <i class="fa fa-pencil"></i> {{ trans('userlist::userlists.button.create userlist') }}
                    </a>
                </div>
            </div> -->
            <div class="box box-primary">
                <div class="box-header">
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="data-table table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Profile</th>
                                <th>Details</th>
                                <th>Account Information</th>
                                <th>Status</th>
                                <th>{{ trans('core::core.table.created at') }}</th>
                                <th data-sortable="false">{{ trans('core::core.table.actions') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if (isset($userlists)): ?>
                            <?php foreach ($userlists as $userlist): ?>
                            <tr>
                                <td>{{ $userlist->member_id }}</td>
                                <td>{{ $userlist->first_name }} {{ $userlist->last_name }} <br>
                                    <?php if(isset($userlist->bio)) { ?>
                                        Bio: <br>
                                        {{ $userlist->bio }} <br>
                                    <?php } ?>
                                </td>
                                <td>
                                    <?php if(isset($userlist->photo)) { ?>
                                        <img src="{{ URL::asset($userlist->photo)}}"  width="100" height="100">
                                    <?php } else { ?>
                                        <img src="{{ URL::asset('assets/media/default.png')}}"  width="100" height="100">
                                    <?php } ?>
                                </td>
                                <td>Email: {{ $userlist->email }} <br> 
                                    Phone: {{ $userlist->phone }} <br> 
                                    Category: {{ $userlist->category }} <br>
                                    
                                    Facebook: <a href="https://www.facebook.com/{{ $userlist->facebook }}" target="_Blank">Click Here</a> <br>
                                    Instagram: <a href="https://www.instagram.com/{{ $userlist->instagram }}" target="_Blank">Click Here</a> <br>
                                    Twitter: <a href="https://www.twitter.com/{{ $userlist->twitter }}" target="_Blank">Click Here</a> <br>
                                    Youtube: <a href="https://www.youtube.com/{{ $userlist->youtube }}" target="_Blank">Click Here</a> <br>
                                    <?php if(isset($userlist->cheque_image)) { ?>
                                        Address Proof: 
                                        <a href="{{ URL::asset($userlist->cheque_image)}}" target="_Blank">Click Here</a>
                                    <?php } ?>
                                </td>
                                <td>Phone Pe: {{ $userlist->phone_pe }} <br> 
                                    PayTM: {{ $userlist->google_pay }} <br> 
                                    BHIM UPI: {{ $userlist->bhim }} <br>
                                    Account Name: {{ $userlist->account_holder_name }} <br>
                                    Account Number: {{ $userlist->account_number }} <br>
                                    IFSC: {{ $userlist->ifsc_code }} <br>
                                    Branch: {{ $userlist->branch }} 
                                </td>
                                <td> 
                                    <?php if ($userlist->status == 1) { ?>
                                       <b style="color: green;">Active</b>
                                    <?php } else { ?>
                                        <b style="color: red;">Inactive</b>
                                    <?php } ?>
                                </td>
                                <td>
                                    <!-- <a href="{{ route('admin.userlist.userlist.edit', [$userlist->id]) }}"> -->
                                        {{ $userlist->created_at }}
                                    <!-- </a> -->
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.userlist.userlist.edit', [$userlist->id]) }}" class="btn btn-default btn-flat"><i class="fa fa-pencil"></i></a>
                                        <!-- <button class="btn btn-danger btn-flat" data-toggle="modal" data-target="#modal-delete-confirmation" data-action-target="{{ route('admin.userlist.userlist.destroy', [$userlist->id]) }}"><i class="fa fa-trash"></i></button> -->
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                            <!-- <tfoot>
                            <tr>
                                <th>{{ trans('core::core.table.created at') }}</th>
                                <th>{{ trans('core::core.table.actions') }}</th>
                            </tr>
                            </tfoot> -->
                        </table>
                        <!-- /.box-body -->
                    </div>
                </div>
                <!-- /.box -->
            </div>
        </div>
    </div>
    @include('core::partials.delete-modal')
@stop

@section('footer')
    <a data-toggle="modal" data-target="#keyboardShortcutsModal"><i class="fa fa-keyboard-o"></i></a> &nbsp;
@stop
@section('shortcuts')
    <dl class="dl-horizontal">
        <dt><code>c</code></dt>
        <dd>{{ trans('userlist::userlists.title.create userlist') }}</dd>
    </dl>
@stop

@push('js-stack')
    <script type="text/javascript">
        $( document ).ready(function() {
            $(document).keypressAction({
                actions: [
                    { key: 'c', route: "<?= route('admin.userlist.userlist.create') ?>" }
                ]
            });
        });
    </script>
    <?php $locale = locale(); ?>
    <script type="text/javascript">
        $(function () {
            $('.data-table').dataTable({
                "paginate": true,
                "lengthChange": true,
                "filter": true,
                "sort": true,
                "info": true,
                "autoWidth": true,
                "order": [[ 0, "desc" ]],
                "language": {
                    "url": '<?php echo Module::asset("core:js/vendor/datatables/{$locale}.json") ?>'
                }
            });
        });
    </script>
@endpush
