<?php

namespace Modules\Wallet\Events\Handlers;

use Maatwebsite\Sidebar\Group;
use Maatwebsite\Sidebar\Item;
use Maatwebsite\Sidebar\Menu;
use Modules\Core\Events\BuildingSidebar;
use Modules\User\Contracts\Authentication;

class RegisterWalletSidebar implements \Maatwebsite\Sidebar\SidebarExtender
{
    /**
     * @var Authentication
     */
    protected $auth;

    /**
     * @param Authentication $auth
     *
     * @internal param Guard $guard
     */
    public function __construct(Authentication $auth)
    {
        $this->auth = $auth;
    }

    public function handle(BuildingSidebar $sidebar)
    {
        $sidebar->add($this->extendWith($sidebar->getMenu()));
    }

    /**
     * @param Menu $menu
     * @return Menu
     */
    public function extendWith(Menu $menu)
    {
        $menu->group(trans('core::sidebar.content'), function (Group $group) {
            $group->item(trans('wallet::wallets.title.wallets'), function (Item $item) {
                $item->icon('fa fa-money');
                $item->weight(10);
                $item->authorize(
                     /* append */
                );
                $item->item(trans('wallet::wallets.title.wallets'), function (Item $item) {
                    $item->icon('fa fa-money');
                    $item->weight(0);
                    // $item->append('admin.wallet.wallet.create');
                    $item->route('admin.wallet.wallet.index');
                    $item->authorize(
                        $this->auth->hasAccess('wallet.wallets.index')
                    );
                });
                $item->item(trans('wallet::transactions.title.transactions'), function (Item $item) {
                    $item->icon('fa fa-dollar');
                    $item->weight(0);
                    // $item->append('admin.wallet.transaction.create');
                    $item->route('admin.wallet.transaction.index');
                    $item->authorize(
                        $this->auth->hasAccess('wallet.transactions.index')
                    );
                });
// append


            });
        });

        return $menu;
    }
}
