<?php

namespace Modules\Wallet\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Wallet\Entities\Transaction;
use Modules\Wallet\Http\Requests\CreateTransactionRequest;
use Modules\Wallet\Http\Requests\UpdateTransactionRequest;
use Modules\Wallet\Repositories\TransactionRepository;
use Modules\Core\Http\Controllers\Admin\AdminBaseController;
use Modules\Userlist\Repositories\UserlistRepository;
use Modules\Event\Repositories\EventRepository;
use DB;

class TransactionController extends AdminBaseController
{
    /**
     * @var TransactionRepository
     */
    private $transaction;

    public function __construct(TransactionRepository $transaction, UserlistRepository $userlist, EventRepository $event)
    {
        parent::__construct();

        $this->transaction = $transaction;
        $this->userlist = $userlist;
        $this->event = $event;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $transactions = $this->transaction->all();

        return view('wallet::admin.transactions.index', compact('transactions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        $userlists = $this->userlist->all();
        $events = $this->event->all();

        return view('wallet::admin.transactions.create', compact('userlists','events'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CreateTransactionRequest $request
     * @return Response
     */
    public function store(CreateTransactionRequest $request)
    {
        $request->merge(['status' => 1, 'type' => 0]);

        $this->transaction->create($request->all());

        return redirect()->route('admin.wallet.transaction.index')
            ->withSuccess(trans('core::core.messages.resource created', ['name' => trans('wallet::transactions.title.transactions')]));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Transaction $transaction
     * @return Response
     */
    public function edit(Transaction $transaction)
    {
        return view('wallet::admin.transactions.edit', compact('transaction'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Transaction $transaction
     * @param  UpdateTransactionRequest $request
     * @return Response
     */
    public function update(Transaction $transaction, UpdateTransactionRequest $request)
    {
        $tt = rand ( 100000 , 999999);
        $ttt = "itigaa".$tt;
         $fff = DB::table('wallet__transactions')->where('id', $request->id)->update(['amount' => $request->amount,'transaction_id' => $ttt, 'status' => 4]);

         // $waa = DB::table('wallet__transactions')
         //              ->where('id', $request->id)
         //              ->update(['type' => 3]);

        $this->transaction->update($transaction, $request->all());

        return redirect()->route('admin.wallet.transaction.index')
            ->withSuccess(trans('core::core.messages.resource updated', ['name' => trans('wallet::transactions.title.transactions')]));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Transaction $transaction
     * @return Response
     */
    public function destroy(Transaction $transaction)
    {
        $this->transaction->destroy($transaction);

        return redirect()->route('admin.wallet.transaction.index')
            ->withSuccess(trans('core::core.messages.resource deleted', ['name' => trans('wallet::transactions.title.transactions')]));
    }
}
