<?php

use Illuminate\Routing\Router;
/** @var Router $router */

$router->group(['prefix' =>'/wallet'], function (Router $router) {
    $router->bind('wallet', function ($id) {
        return app('Modules\Wallet\Repositories\WalletRepository')->find($id);
    });
    $router->get('wallets', [
        'as' => 'admin.wallet.wallet.index',
        'uses' => 'WalletController@index',
        'middleware' => 'can:wallet.wallets.index'
    ]);
    $router->get('wallets/create', [
        'as' => 'admin.wallet.wallet.create',
        'uses' => 'WalletController@create',
        'middleware' => 'can:wallet.wallets.create'
    ]);
    $router->post('wallets', [
        'as' => 'admin.wallet.wallet.store',
        'uses' => 'WalletController@store',
        'middleware' => 'can:wallet.wallets.create'
    ]);
    $router->get('wallets/{wallet}/edit', [
        'as' => 'admin.wallet.wallet.edit',
        'uses' => 'WalletController@edit',
        'middleware' => 'can:wallet.wallets.edit'
    ]);
    $router->put('wallets/{wallet}', [
        'as' => 'admin.wallet.wallet.update',
        'uses' => 'WalletController@update',
        'middleware' => 'can:wallet.wallets.edit'
    ]);
    $router->delete('wallets/{wallet}', [
        'as' => 'admin.wallet.wallet.destroy',
        'uses' => 'WalletController@destroy',
        'middleware' => 'can:wallet.wallets.destroy'
    ]);
    $router->bind('transaction', function ($id) {
        return app('Modules\Wallet\Repositories\TransactionRepository')->find($id);
    });
    $router->get('transactions', [
        'as' => 'admin.wallet.transaction.index',
        'uses' => 'TransactionController@index',
        'middleware' => 'can:wallet.transactions.index'
    ]);
    $router->get('transactions/create', [
        'as' => 'admin.wallet.transaction.create',
        'uses' => 'TransactionController@create',
        'middleware' => 'can:wallet.transactions.create'
    ]);
    $router->post('transactions', [
        'as' => 'admin.wallet.transaction.store',
        'uses' => 'TransactionController@store',
        'middleware' => 'can:wallet.transactions.create'
    ]);
    $router->get('transactions/{transaction}/edit', [
        'as' => 'admin.wallet.transaction.edit',
        'uses' => 'TransactionController@edit',
        'middleware' => 'can:wallet.transactions.edit'
    ]);
    $router->put('transactions/{transaction}', [
        'as' => 'admin.wallet.transaction.update',
        'uses' => 'TransactionController@update',
        'middleware' => 'can:wallet.transactions.edit'
    ]);
    $router->delete('transactions/{transaction}', [
        'as' => 'admin.wallet.transaction.destroy',
        'uses' => 'TransactionController@destroy',
        'middleware' => 'can:wallet.transactions.destroy'
    ]);
// append


});
