<?php

namespace Modules\Wallet\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Core\Traits\CanPublishConfiguration;
use Modules\Core\Events\BuildingSidebar;
use Modules\Core\Events\LoadingBackendTranslations;
use Modules\Wallet\Events\Handlers\RegisterWalletSidebar;

class WalletServiceProvider extends ServiceProvider
{
    use CanPublishConfiguration;
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->registerBindings();
        $this->app['events']->listen(BuildingSidebar::class, RegisterWalletSidebar::class);

        $this->app['events']->listen(LoadingBackendTranslations::class, function (LoadingBackendTranslations $event) {
            $event->load('wallets', array_dot(trans('wallet::wallets')));
            $event->load('transactions', array_dot(trans('wallet::transactions')));
            // append translations


        });
    }

    public function boot()
    {
        $this->publishConfig('wallet', 'permissions');

        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return array();
    }

    private function registerBindings()
    {
        $this->app->bind(
            'Modules\Wallet\Repositories\WalletRepository',
            function () {
                $repository = new \Modules\Wallet\Repositories\Eloquent\EloquentWalletRepository(new \Modules\Wallet\Entities\Wallet());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Wallet\Repositories\Cache\CacheWalletDecorator($repository);
            }
        );
        $this->app->bind(
            'Modules\Wallet\Repositories\TransactionRepository',
            function () {
                $repository = new \Modules\Wallet\Repositories\Eloquent\EloquentTransactionRepository(new \Modules\Wallet\Entities\Transaction());

                if (! config('app.cache')) {
                    return $repository;
                }

                return new \Modules\Wallet\Repositories\Cache\CacheTransactionDecorator($repository);
            }
        );
// add bindings


    }
}
