@extends('layouts.master')

@section('content-header')
    <h1>
        {{ trans('wallet::transactions.title.transactions') }}
    </h1>
    <ol class="breadcrumb">
        <li><a href="{{ route('dashboard.index') }}"><i class="fa fa-dashboard"></i> {{ trans('core::core.breadcrumb.home') }}</a></li>
        <li class="active">{{ trans('wallet::transactions.title.transactions') }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-xs-12">
            <div class="row">
                <div class="btn-group pull-right" style="margin: 0 15px 15px 0;">
                    <a href="{{ route('admin.wallet.transaction.create') }}" class="btn btn-primary btn-flat" style="padding: 4px 10px;">
                        <i class="fa fa-pencil"></i> {{ trans('wallet::transactions.button.create transaction') }}
                    </a>
                </div>
            </div>
            <div class="box box-primary">
                <div class="box-header">
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="data-table table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>Id</th>
                                <th>Customer Name</th>
                                <th>Transaction Details</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <!-- <th>Type</th> -->
                                <!-- <th>{{ trans('core::core.table.created at') }}</th> -->
                                <th data-sortable="false">{{ trans('core::core.table.actions') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if (isset($transactions)): ?>
                            <?php foreach ($transactions as $transaction): ?>
                            <tr>
                                <td>{{ $transaction->id }}</td>
                                <td>{{ $transaction->user['first_name'] }} {{ $transaction->user['last_name'] }}</td>
                                <td>
                                    <?php if($transaction->transaction_id == 1){ ?>
                                        By Event 
                                    <?php }else{ ?>
                                        {{ $transaction->transaction_id }}</td>
                                    <?php } ?>
                                <td>{{ $transaction->amount }}</td>
                                <td>
                                    <?php if ($transaction->status == 1) { ?>
                                       <b style="color: green;">Credited to wallet</b>
                                    <?php }elseif ($transaction->status == 3) { ?>
                                       <b style="color: orange;">Requested</b>
                                    <?php }elseif ($transaction->status == 4) { ?>
                                       <b style="color: blue;">Amount Transfered</b>
                                    <?php } ?>
                                </td>
                                <!-- <td>
                                    <?php if ($transaction->type == 1) { ?>
                                       <b style="color: orange;">Requested</b>
                                    <?php }elseif ($transaction->type == 3) { ?>
                                       <b style="color: blue;">By Request</b>
                                    <?php }elseif ($transaction->type == 2) { ?>
                                       <b style="color: green;">Payment Done</b>
                                    <?php } else { ?>
                                        <b style="color: red;">-</b>
                                    <?php } ?>
                                </td> -->
                                <!-- <td> -->
                                    <!-- <a href="{{ route('admin.wallet.transaction.edit', [$transaction->id]) }}"> -->
                                        <!-- {{ $transaction->created_at }} -->
                                    <!-- </a> -->
                                <!-- </td> -->
                                <td>
                                    <div class="btn-group">
                                        <?php if($transaction->status == 3){ ?>
                                            <a href="{{ route('admin.wallet.transaction.edit', [$transaction->id]) }}" class="btn btn-default btn-flat"><i class="fa fa-pencil"></i></a>
                                        <?php }else{

                                        } ?>
                                        <!-- <button class="btn btn-danger btn-flat" data-toggle="modal" data-target="#modal-delete-confirmation" data-action-target="{{ route('admin.wallet.transaction.destroy', [$transaction->id]) }}"><i class="fa fa-trash"></i></button> -->
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                            <!-- <tfoot>
                            <tr>
                                <th>{{ trans('core::core.table.created at') }}</th>
                                <th>{{ trans('core::core.table.actions') }}</th>
                            </tr>
                            </tfoot> -->
                        </table>
                        <!-- /.box-body -->
                    </div>
                </div>
                <!-- /.box -->
            </div>
        </div>
    </div>
    @include('core::partials.delete-modal')
@stop

@section('footer')
    <a data-toggle="modal" data-target="#keyboardShortcutsModal"><i class="fa fa-keyboard-o"></i></a> &nbsp;
@stop
@section('shortcuts')
    <dl class="dl-horizontal">
        <dt><code>c</code></dt>
        <dd>{{ trans('wallet::transactions.title.create transaction') }}</dd>
    </dl>
@stop

@push('js-stack')
    <script type="text/javascript">
        $( document ).ready(function() {
            $(document).keypressAction({
                actions: [
                    { key: 'c', route: "<?= route('admin.wallet.transaction.create') ?>" }
                ]
            });
        });
    </script>
    <?php $locale = locale(); ?>
    <script type="text/javascript">
        $(function () {
            $('.data-table').dataTable({
                "paginate": true,
                "lengthChange": true,
                "filter": true,
                "sort": true,
                "info": true,
                "autoWidth": true,
                "order": [[ 0, "desc" ]],
                "language": {
                    "url": '<?php echo Module::asset("core:js/vendor/datatables/{$locale}.json") ?>'
                }
            });
        });
    </script>
@endpush
