<?php $__env->startSection('content-header'); ?>
    <h1>
        <?php echo e(trans('event::events.title.events')); ?>

    </h1>
    <ol class="breadcrumb">
        <li><a href="<?php echo e(route('dashboard.index')); ?>"><i class="fa fa-dashboard"></i> <?php echo e(trans('core::core.breadcrumb.home')); ?></a></li>
        <li class="active"><?php echo e(trans('event::events.title.events')); ?></li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xs-12">
            <div class="row">
                <div class="btn-group pull-right" style="margin: 0 15px 15px 0;">
                    <a href="<?php echo e(route('admin.event.event.create')); ?>" class="btn btn-primary btn-flat" style="padding: 4px 10px;">
                        <i class="fa fa-pencil"></i> <?php echo e(trans('event::events.button.create event')); ?>

                    </a>
                </div>
            </div>
            <div class="box box-primary">
                <div class="box-header">
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="data-table table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>Category</th>
                                <th>Location</th>
                                <th>Name</th>
                                <th>Details</th>
                                <th>Required Resources</th>
                                <!-- <th>Short Description</th>
                                <th>Description</th>
                                <th>Image</th> -->
                                <th>status</th>
                                <th>Manager Assigned</th>
                                <th><?php echo e(trans('core::core.table.created at')); ?></th>
                                <th data-sortable="false"><?php echo e(trans('core::core.table.actions')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if (isset($events)): ?>
                            <?php foreach ($events as $event): ?>
                            <tr>
                                <td><?php echo e($event->id); ?></td>
                                <td>
                                    
                                    <?php echo e($event->category['name']); ?>

                                </td>
                                <td><?php echo e($event->location['name']); ?></td>
                                <td><?php echo e($event->name); ?></td>
                                <td><b>From :</b> <?php echo e($event->event_date); ?> <br> <?php echo e($event->event_time); ?><br><b>To :</b> <?php echo e($event->todate); ?> <br> <?php echo e($event->totime); ?></td>
                                <td><?php echo e($event->req_volunteer); ?></td>

                                <td> 
                                    <?php if ($event->status == 1) { ?>
                                       <b style="color: blue;">Active</b>
                                    <?php }elseif ($event->status == 0) { ?>
                                       <b style="color: green;">Active</b>
                                    <?php } else { ?>
                                        <b style="color: green;">Completed</b>
                                    <?php } ?>
                                 </td>
                                 <td>
                                    <?php if(isset($event->manager_id) && !empty($event->manager_id)) { ?>
                                    <?php $user = DB::table('userlist__managers')->where('user_id', '=', $event->manager_id)->get(); ?>
                                            <?php if(isset($user[0]->first_name)) { ?>
                                            <?php echo e($user[0]->first_name); ?> <?php echo e($user[0]->last_name); ?> <br><?php echo e($user[0]->phone); ?>

                                        <?php } }?>
                                </td>
                                <td>
                                    <?php echo e($event->created_at); ?>

                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('admin.event.event.edit', [$event->id])); ?>?id=1" class="btn btn-default btn-flat"><i class="fa fa-pencil"></i></a>
                                        <br>
                                        <?php if(isset($event->manager_id)) { ?>
                                             <a href="<?php echo e(route('admin.event.event.edit', [$event->id])); ?>?id=2" class="btn btn-default btn-flat">Re Assign</a>
                                        <?php } else { ?>
                                            <a href="<?php echo e(route('admin.event.event.edit', [$event->id])); ?>?id=2" class="btn btn-default btn-flat">Assign</a>
                                        <?php } ?><br>
                                            <a href="<?php echo e(route('admin.event.eventdetails.index')); ?>?id=<?php echo e($event->id); ?>" class="btn btn-default btn-flat">Enrolls</a><br>
                                            <?php if($event->status == 1 || $event->status == 2){ ?>
                                                <a href="<?php echo e(route('admin.event.event.edit', [$event->id])); ?>?id=3" class="btn btn-default btn-flat">Status</a><br>
                                            <?php }else{

                                            } ?>
                                        <button class="btn btn-danger btn-flat" data-toggle="modal" data-target="#modal-delete-confirmation" data-action-target="<?php echo e(route('admin.event.event.destroy', [$event->id])); ?>"><i class="fa fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                            <!-- <tfoot>
                            <tr>
                                <th><?php echo e(trans('core::core.table.created at')); ?></th>
                                <th><?php echo e(trans('core::core.table.actions')); ?></th>
                            </tr>
                            </tfoot> -->
                        </table>
                        <!-- /.box-body -->
                    </div>
                </div>
                <!-- /.box -->
            </div>
        </div>
    </div>
    <?php echo $__env->make('core::partials.delete-modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <a data-toggle="modal" data-target="#keyboardShortcutsModal"><i class="fa fa-keyboard-o"></i></a> &nbsp;
<?php $__env->stopSection(); ?>
<?php $__env->startSection('shortcuts'); ?>
    <dl class="dl-horizontal">
        <dt><code>c</code></dt>
        <dd><?php echo e(trans('event::events.title.create event')); ?></dd>
    </dl>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js-stack'); ?>
    <script type="text/javascript">
        $( document ).ready(function() {
            $(document).keypressAction({
                actions: [
                    { key: 'c', route: "<?= route('admin.event.event.create') ?>" }
                ]
            });
        });
    </script>
    <?php $locale = locale(); ?>
    <script type="text/javascript">
        $(function () {
            $('.data-table').dataTable({
                "paginate": true,
                "lengthChange": true,
                "filter": true,
                "sort": true,
                "info": true,
                "autoWidth": true,
                "order": [[ 0, "desc" ]],
                "language": {
                    "url": '<?php echo Module::asset("core:js/vendor/datatables/{$locale}.json") ?>'
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>