<div class="modal fade modal-danger" id="modal-delete-confirmation" tabindex="-1" role="dialog" aria-labelledby="delete-confirmation-title" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <h4 class="modal-title" id="delete-confirmation-title"><?php echo e(trans('core::core.modal.title')); ?></h4>
            </div>
            <div class="modal-body">
                <div class="default-message">
                    <?php if(isset($message)): ?>
                        <?php echo $message; ?>

                    <?php else: ?>
                        <?php echo e(trans('core::core.modal.confirmation-message')); ?>

                    <?php endif; ?>
                </div>
                <div class="custom-message"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline btn-flat" data-dismiss="modal"><?php echo e(trans('core::core.button.cancel')); ?></button>
                <?php echo Form::open(['method' => 'delete', 'class' => 'pull-left']); ?>

                <button type="submit" class="btn btn-outline btn-flat"><i class="fa fa-trash"></i> <?php echo e(trans('core::core.button.delete')); ?></button>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('js-stack'); ?>
<script>
    $( document ).ready(function() {
        $('#modal-delete-confirmation').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var actionTarget = button.data('action-target');
            var modal = $(this);
            modal.find('form').attr('action', actionTarget);

            if (button.data('message') === undefined) {
            } else if (button.data('message') != '') {
                modal.find('.custom-message').show().empty().append(button.data('message'));
                modal.find('.default-message').hide();
            } else {
                modal.find('.default-message').show();
                modal.find('.custom-message').hide();
            }

            if (button.data('remove-submit-button') === true) {
                modal.find('button[type=submit]').hide();
            } else {
                modal.find('button[type=submit]').show();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
